package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDbSecurityGroupsResponse(
    marker: scala.Option[String] = None,
    dbSecurityGroups: scala.Option[Iterable[
      zio.aws.rds.model.DBSecurityGroup
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse = {
    import DescribeDbSecurityGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbSecurityGroups)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbSecurityGroupsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbSecurityGroupsResponse.wrap(buildAwsValue())
}
object DescribeDbSecurityGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbSecurityGroupsResponse =
      zio.aws.rds.model.DescribeDbSecurityGroupsResponse(
        marker.map(value => value),
        dbSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: scala.Option[String]
    def dbSecurityGroups
        : scala.Option[List[zio.aws.rds.model.DBSecurityGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbSecurityGroups
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBSecurityGroup.ReadOnly]] =
      AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse
  ) extends zio.aws.rds.model.DescribeDbSecurityGroupsResponse.ReadOnly {
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val dbSecurityGroups
        : scala.Option[List[zio.aws.rds.model.DBSecurityGroup.ReadOnly]] = scala
      .Option(impl.dbSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBSecurityGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse
  ): zio.aws.rds.model.DescribeDbSecurityGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
