package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteInstallationMediaRequest(installationMediaId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteInstallationMediaRequest = {
    import DeleteInstallationMediaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteInstallationMediaRequest
      .builder()
      .installationMediaId(installationMediaId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteInstallationMediaRequest.ReadOnly =
    zio.aws.rds.model.DeleteInstallationMediaRequest.wrap(buildAwsValue())
}
object DeleteInstallationMediaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteInstallationMediaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteInstallationMediaRequest =
      zio.aws.rds.model.DeleteInstallationMediaRequest(installationMediaId)
    def installationMediaId: String
    def getInstallationMediaId: ZIO[Any, Nothing, String] =
      ZIO.succeed(installationMediaId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteInstallationMediaRequest
  ) extends zio.aws.rds.model.DeleteInstallationMediaRequest.ReadOnly {
    override val installationMediaId: String =
      impl.installationMediaId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteInstallationMediaRequest
  ): zio.aws.rds.model.DeleteInstallationMediaRequest.ReadOnly = new Wrapper(
    impl
  )
}
