package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteDbClusterResponse(
    dbCluster: scala.Option[zio.aws.rds.model.DBCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse = {
    import DeleteDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbClusterResponse.ReadOnly =
    zio.aws.rds.model.DeleteDbClusterResponse.wrap(buildAwsValue())
}
object DeleteDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbClusterResponse =
      zio.aws.rds.model
        .DeleteDbClusterResponse(dbCluster.map(value => value.asEditable))
    def dbCluster: scala.Option[zio.aws.rds.model.DBCluster.ReadOnly]
    def getDbCluster: ZIO[Any, AwsError, zio.aws.rds.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse
  ) extends zio.aws.rds.model.DeleteDbClusterResponse.ReadOnly {
    override val dbCluster: scala.Option[zio.aws.rds.model.DBCluster.ReadOnly] =
      scala
        .Option(impl.dbCluster())
        .map(value => zio.aws.rds.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse
  ): zio.aws.rds.model.DeleteDbClusterResponse.ReadOnly = new Wrapper(impl)
}
