package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DBSecurityGroup(
    ownerId: scala.Option[String] = None,
    dbSecurityGroupName: scala.Option[String] = None,
    dbSecurityGroupDescription: scala.Option[String] = None,
    vpcId: scala.Option[String] = None,
    ec2SecurityGroups: scala.Option[Iterable[
      zio.aws.rds.model.EC2SecurityGroup
    ]] = None,
    ipRanges: scala.Option[Iterable[zio.aws.rds.model.IPRange]] = None,
    dbSecurityGroupArn: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBSecurityGroup = {
    import DBSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBSecurityGroup
      .builder()
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        dbSecurityGroupName.map(value => value: java.lang.String)
      )(_.dbSecurityGroupName)
      .optionallyWith(
        dbSecurityGroupDescription.map(value => value: java.lang.String)
      )(_.dbSecurityGroupDescription)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        ec2SecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2SecurityGroups)
      .optionallyWith(
        ipRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipRanges)
      .optionallyWith(dbSecurityGroupArn.map(value => value: java.lang.String))(
        _.dbSecurityGroupArn
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBSecurityGroup.ReadOnly =
    zio.aws.rds.model.DBSecurityGroup.wrap(buildAwsValue())
}
object DBSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBSecurityGroup =
      zio.aws.rds.model.DBSecurityGroup(
        ownerId.map(value => value),
        dbSecurityGroupName.map(value => value),
        dbSecurityGroupDescription.map(value => value),
        vpcId.map(value => value),
        ec2SecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbSecurityGroupArn.map(value => value)
      )
    def ownerId: scala.Option[String]
    def dbSecurityGroupName: scala.Option[String]
    def dbSecurityGroupDescription: scala.Option[String]
    def vpcId: scala.Option[String]
    def ec2SecurityGroups
        : scala.Option[List[zio.aws.rds.model.EC2SecurityGroup.ReadOnly]]
    def ipRanges: scala.Option[List[zio.aws.rds.model.IPRange.ReadOnly]]
    def dbSecurityGroupArn: scala.Option[String]
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getDbSecurityGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSecurityGroupName", dbSecurityGroupName)
    def getDbSecurityGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbSecurityGroupDescription",
        dbSecurityGroupDescription
      )
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getEc2SecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.EC2SecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2SecurityGroups", ec2SecurityGroups)
    def getIpRanges
        : ZIO[Any, AwsError, List[zio.aws.rds.model.IPRange.ReadOnly]] =
      AwsError.unwrapOptionField("ipRanges", ipRanges)
    def getDbSecurityGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSecurityGroupArn", dbSecurityGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBSecurityGroup
  ) extends zio.aws.rds.model.DBSecurityGroup.ReadOnly {
    override val ownerId: scala.Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val dbSecurityGroupName: scala.Option[String] =
      scala.Option(impl.dbSecurityGroupName()).map(value => value: String)
    override val dbSecurityGroupDescription: scala.Option[String] = scala
      .Option(impl.dbSecurityGroupDescription())
      .map(value => value: String)
    override val vpcId: scala.Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val ec2SecurityGroups
        : scala.Option[List[zio.aws.rds.model.EC2SecurityGroup.ReadOnly]] =
      scala
        .Option(impl.ec2SecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.EC2SecurityGroup.wrap(item)
          }.toList
        )
    override val ipRanges
        : scala.Option[List[zio.aws.rds.model.IPRange.ReadOnly]] = scala
      .Option(impl.ipRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.IPRange.wrap(item)
        }.toList
      )
    override val dbSecurityGroupArn: scala.Option[String] =
      scala.Option(impl.dbSecurityGroupArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBSecurityGroup
  ): zio.aws.rds.model.DBSecurityGroup.ReadOnly = new Wrapper(impl)
}
