package zio.aws.rds.model
import zio.aws.rds.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DBProxyTarget(
    targetArn: scala.Option[String] = None,
    endpoint: scala.Option[String] = None,
    trackedClusterId: scala.Option[String] = None,
    rdsResourceId: scala.Option[String] = None,
    port: scala.Option[Integer] = None,
    `type`: scala.Option[zio.aws.rds.model.TargetType] = None,
    role: scala.Option[zio.aws.rds.model.TargetRole] = None,
    targetHealth: scala.Option[zio.aws.rds.model.TargetHealth] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBProxyTarget = {
    import DBProxyTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBProxyTarget
      .builder()
      .optionallyWith(targetArn.map(value => value: java.lang.String))(
        _.targetArn
      )
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(trackedClusterId.map(value => value: java.lang.String))(
        _.trackedClusterId
      )
      .optionallyWith(rdsResourceId.map(value => value: java.lang.String))(
        _.rdsResourceId
      )
      .optionallyWith(
        port.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.port)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(role.map(value => value.unwrap))(_.role)
      .optionallyWith(targetHealth.map(value => value.buildAwsValue()))(
        _.targetHealth
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBProxyTarget.ReadOnly =
    zio.aws.rds.model.DBProxyTarget.wrap(buildAwsValue())
}
object DBProxyTarget {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBProxyTarget] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBProxyTarget =
      zio.aws.rds.model.DBProxyTarget(
        targetArn.map(value => value),
        endpoint.map(value => value),
        trackedClusterId.map(value => value),
        rdsResourceId.map(value => value),
        port.map(value => value),
        `type`.map(value => value),
        role.map(value => value),
        targetHealth.map(value => value.asEditable)
      )
    def targetArn: scala.Option[String]
    def endpoint: scala.Option[String]
    def trackedClusterId: scala.Option[String]
    def rdsResourceId: scala.Option[String]
    def port: scala.Option[Integer]
    def `type`: scala.Option[zio.aws.rds.model.TargetType]
    def role: scala.Option[zio.aws.rds.model.TargetRole]
    def targetHealth: scala.Option[zio.aws.rds.model.TargetHealth.ReadOnly]
    def getTargetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getTrackedClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trackedClusterId", trackedClusterId)
    def getRdsResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rdsResourceId", rdsResourceId)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getType: ZIO[Any, AwsError, zio.aws.rds.model.TargetType] =
      AwsError.unwrapOptionField("type", `type`)
    def getRole: ZIO[Any, AwsError, zio.aws.rds.model.TargetRole] =
      AwsError.unwrapOptionField("role", role)
    def getTargetHealth
        : ZIO[Any, AwsError, zio.aws.rds.model.TargetHealth.ReadOnly] =
      AwsError.unwrapOptionField("targetHealth", targetHealth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBProxyTarget
  ) extends zio.aws.rds.model.DBProxyTarget.ReadOnly {
    override val targetArn: scala.Option[String] =
      scala.Option(impl.targetArn()).map(value => value: String)
    override val endpoint: scala.Option[String] =
      scala.Option(impl.endpoint()).map(value => value: String)
    override val trackedClusterId: scala.Option[String] =
      scala.Option(impl.trackedClusterId()).map(value => value: String)
    override val rdsResourceId: scala.Option[String] =
      scala.Option(impl.rdsResourceId()).map(value => value: String)
    override val port: scala.Option[Integer] = scala
      .Option(impl.port())
      .map(value => zio.aws.rds.model.primitives.Integer(value))
    override val `type`: scala.Option[zio.aws.rds.model.TargetType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.rds.model.TargetType.wrap(value))
    override val role: scala.Option[zio.aws.rds.model.TargetRole] = scala
      .Option(impl.role())
      .map(value => zio.aws.rds.model.TargetRole.wrap(value))
    override val targetHealth
        : scala.Option[zio.aws.rds.model.TargetHealth.ReadOnly] = scala
      .Option(impl.targetHealth())
      .map(value => zio.aws.rds.model.TargetHealth.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBProxyTarget
  ): zio.aws.rds.model.DBProxyTarget.ReadOnly = new Wrapper(impl)
}
