package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDbSubnetGroupResponse(
    dbSubnetGroup: scala.Option[zio.aws.rds.model.DBSubnetGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse = {
    import CreateDbSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse
      .builder()
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbSubnetGroupResponse.ReadOnly =
    zio.aws.rds.model.CreateDbSubnetGroupResponse.wrap(buildAwsValue())
}
object CreateDbSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbSubnetGroupResponse =
      zio.aws.rds.model.CreateDbSubnetGroupResponse(
        dbSubnetGroup.map(value => value.asEditable)
      )
    def dbSubnetGroup: scala.Option[zio.aws.rds.model.DBSubnetGroup.ReadOnly]
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.rds.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse
  ) extends zio.aws.rds.model.CreateDbSubnetGroupResponse.ReadOnly {
    override val dbSubnetGroup
        : scala.Option[zio.aws.rds.model.DBSubnetGroup.ReadOnly] = scala
      .Option(impl.dbSubnetGroup())
      .map(value => zio.aws.rds.model.DBSubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse
  ): zio.aws.rds.model.CreateDbSubnetGroupResponse.ReadOnly = new Wrapper(impl)
}
