package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AvailabilityZone(name: scala.Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.AvailabilityZone
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.AvailabilityZone.ReadOnly =
    zio.aws.rds.model.AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.AvailabilityZone =
      zio.aws.rds.model.AvailabilityZone(name.map(value => value))
    def name: scala.Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.AvailabilityZone
  ) extends zio.aws.rds.model.AvailabilityZone.ReadOnly {
    override val name: scala.Option[String] =
      scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.AvailabilityZone
  ): zio.aws.rds.model.AvailabilityZone.ReadOnly = new Wrapper(impl)
}
