package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopDbInstanceAutomatedBackupsReplicationRequest(
    sourceDBInstanceArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest = {
    import StopDbInstanceAutomatedBackupsReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest
      .builder()
      .sourceDBInstanceArn(sourceDBInstanceArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest.ReadOnly =
    zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest
      .wrap(buildAwsValue())
}
object StopDbInstanceAutomatedBackupsReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest =
      zio.aws.rds.model
        .StopDbInstanceAutomatedBackupsReplicationRequest(sourceDBInstanceArn)
    def sourceDBInstanceArn: String
    def getSourceDBInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest
  ) extends zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest.ReadOnly {
    override val sourceDBInstanceArn: String =
      impl.sourceDBInstanceArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest
  ): zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest.ReadOnly =
    new Wrapper(impl)
}
