package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{IntegerOptional, BooleanOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ModifyDbProxyRequest(
    dbProxyName: String,
    newDBProxyName: Optional[String] = Optional.Absent,
    auth: Optional[Iterable[zio.aws.rds.model.UserAuthConfig]] =
      Optional.Absent,
    requireTLS: Optional[BooleanOptional] = Optional.Absent,
    idleClientTimeout: Optional[IntegerOptional] = Optional.Absent,
    debugLogging: Optional[BooleanOptional] = Optional.Absent,
    roleArn: Optional[String] = Optional.Absent,
    securityGroups: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest = {
    import ModifyDbProxyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest
      .builder()
      .dbProxyName(dbProxyName: java.lang.String)
      .optionallyWith(newDBProxyName.map(value => value: java.lang.String))(
        _.newDBProxyName
      )
      .optionallyWith(
        auth.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.auth)
      .optionallyWith(requireTLS.map(value => value: java.lang.Boolean))(
        _.requireTLS
      )
      .optionallyWith(idleClientTimeout.map(value => value: Integer))(
        _.idleClientTimeout
      )
      .optionallyWith(debugLogging.map(value => value: java.lang.Boolean))(
        _.debugLogging
      )
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbProxyRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbProxyRequest.wrap(buildAwsValue())
}
object ModifyDbProxyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbProxyRequest =
      zio.aws.rds.model.ModifyDbProxyRequest(
        dbProxyName,
        newDBProxyName.map(value => value),
        auth.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requireTLS.map(value => value),
        idleClientTimeout.map(value => value),
        debugLogging.map(value => value),
        roleArn.map(value => value),
        securityGroups.map(value => value)
      )
    def dbProxyName: String
    def newDBProxyName: Optional[String]
    def auth: Optional[List[zio.aws.rds.model.UserAuthConfig.ReadOnly]]
    def requireTLS: Optional[BooleanOptional]
    def idleClientTimeout: Optional[IntegerOptional]
    def debugLogging: Optional[BooleanOptional]
    def roleArn: Optional[String]
    def securityGroups: Optional[List[String]]
    def getDbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyName)
    def getNewDBProxyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newDBProxyName", newDBProxyName)
    def getAuth
        : ZIO[Any, AwsError, List[zio.aws.rds.model.UserAuthConfig.ReadOnly]] =
      AwsError.unwrapOptionField("auth", auth)
    def getRequireTLS: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("requireTLS", requireTLS)
    def getIdleClientTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("idleClientTimeout", idleClientTimeout)
    def getDebugLogging: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("debugLogging", debugLogging)
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest
  ) extends zio.aws.rds.model.ModifyDbProxyRequest.ReadOnly {
    override val dbProxyName: String = impl.dbProxyName(): String
    override val newDBProxyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.newDBProxyName())
      .map(value => value: String)
    override val auth
        : Optional[List[zio.aws.rds.model.UserAuthConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auth())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.UserAuthConfig.wrap(item)
          }.toList
        )
    override val requireTLS: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.requireTLS())
      .map(value => value: BooleanOptional)
    override val idleClientTimeout: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idleClientTimeout())
        .map(value => value: IntegerOptional)
    override val debugLogging: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.debugLogging())
      .map(value => value: BooleanOptional)
    override val roleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => value: String)
    override val securityGroups: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest
  ): zio.aws.rds.model.ModifyDbProxyRequest.ReadOnly = new Wrapper(impl)
}
