package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait ExportSourceType {
  def unwrap: software.amazon.awssdk.services.rds.model.ExportSourceType
}
object ExportSourceType {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.ExportSourceType
  ): zio.aws.rds.model.ExportSourceType = value match {
    case software.amazon.awssdk.services.rds.model.ExportSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.ExportSourceType.SNAPSHOT =>
      val r = SNAPSHOT
      r
    case software.amazon.awssdk.services.rds.model.ExportSourceType.CLUSTER =>
      val r = CLUSTER
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.ExportSourceType {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ExportSourceType =
      software.amazon.awssdk.services.rds.model.ExportSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object SNAPSHOT extends zio.aws.rds.model.ExportSourceType {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ExportSourceType =
      software.amazon.awssdk.services.rds.model.ExportSourceType.SNAPSHOT
  }
  case object CLUSTER extends zio.aws.rds.model.ExportSourceType {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ExportSourceType =
      software.amazon.awssdk.services.rds.model.ExportSourceType.CLUSTER
  }
}
