package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbProxyEndpointsResponse(
    dbProxyEndpoints: Optional[Iterable[zio.aws.rds.model.DBProxyEndpoint]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse = {
    import DescribeDbProxyEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse
      .builder()
      .optionallyWith(
        dbProxyEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbProxyEndpoints)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbProxyEndpointsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbProxyEndpointsResponse.wrap(buildAwsValue())
}
object DescribeDbProxyEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbProxyEndpointsResponse =
      zio.aws.rds.model.DescribeDbProxyEndpointsResponse(
        dbProxyEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def dbProxyEndpoints
        : Optional[List[zio.aws.rds.model.DBProxyEndpoint.ReadOnly]]
    def marker: Optional[String]
    def getDbProxyEndpoints
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBProxyEndpoint.ReadOnly]] =
      AwsError.unwrapOptionField("dbProxyEndpoints", dbProxyEndpoints)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse
  ) extends zio.aws.rds.model.DescribeDbProxyEndpointsResponse.ReadOnly {
    override val dbProxyEndpoints
        : Optional[List[zio.aws.rds.model.DBProxyEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbProxyEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBProxyEndpoint.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse
  ): zio.aws.rds.model.DescribeDbProxyEndpointsResponse.ReadOnly = new Wrapper(
    impl
  )
}
