package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbProxiesResponse(
    dbProxies: Optional[Iterable[zio.aws.rds.model.DBProxy]] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse = {
    import DescribeDbProxiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse
      .builder()
      .optionallyWith(
        dbProxies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbProxies)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbProxiesResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbProxiesResponse.wrap(buildAwsValue())
}
object DescribeDbProxiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbProxiesResponse =
      zio.aws.rds.model.DescribeDbProxiesResponse(
        dbProxies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def dbProxies: Optional[List[zio.aws.rds.model.DBProxy.ReadOnly]]
    def marker: Optional[String]
    def getDbProxies
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBProxy.ReadOnly]] =
      AwsError.unwrapOptionField("dbProxies", dbProxies)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse
  ) extends zio.aws.rds.model.DescribeDbProxiesResponse.ReadOnly {
    override val dbProxies: Optional[List[zio.aws.rds.model.DBProxy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbProxies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBProxy.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse
  ): zio.aws.rds.model.DescribeDbProxiesResponse.ReadOnly = new Wrapper(impl)
}
