package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbParametersResponse(
    parameters: Optional[Iterable[zio.aws.rds.model.Parameter]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse = {
    import DescribeDbParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbParametersResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbParametersResponse.wrap(buildAwsValue())
}
object DescribeDbParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbParametersResponse =
      zio.aws.rds.model.DescribeDbParametersResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def parameters: Optional[List[zio.aws.rds.model.Parameter.ReadOnly]]
    def marker: Optional[String]
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse
  ) extends zio.aws.rds.model.DescribeDbParametersResponse.ReadOnly {
    override val parameters
        : Optional[List[zio.aws.rds.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Parameter.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse
  ): zio.aws.rds.model.DescribeDbParametersResponse.ReadOnly = new Wrapper(impl)
}
