package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbParameterGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    dbParameterGroups: Optional[Iterable[zio.aws.rds.model.DBParameterGroup]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse = {
    import DescribeDbParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbParameterGroups)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbParameterGroupsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbParameterGroupsResponse.wrap(buildAwsValue())
}
object DescribeDbParameterGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbParameterGroupsResponse =
      zio.aws.rds.model.DescribeDbParameterGroupsResponse(
        marker.map(value => value),
        dbParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbParameterGroups
        : Optional[List[zio.aws.rds.model.DBParameterGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBParameterGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("dbParameterGroups", dbParameterGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse
  ) extends zio.aws.rds.model.DescribeDbParameterGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbParameterGroups
        : Optional[List[zio.aws.rds.model.DBParameterGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBParameterGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse
  ): zio.aws.rds.model.DescribeDbParameterGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
