package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{Integer, TStamp}
import scala.jdk.CollectionConverters._
final case class CancelExportTaskResponse(
    exportTaskIdentifier: Optional[String] = Optional.Absent,
    sourceArn: Optional[String] = Optional.Absent,
    exportOnly: Optional[Iterable[String]] = Optional.Absent,
    snapshotTime: Optional[TStamp] = Optional.Absent,
    taskStartTime: Optional[TStamp] = Optional.Absent,
    taskEndTime: Optional[TStamp] = Optional.Absent,
    s3Bucket: Optional[String] = Optional.Absent,
    s3Prefix: Optional[String] = Optional.Absent,
    iamRoleArn: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    percentProgress: Optional[Integer] = Optional.Absent,
    totalExtractedDataInGB: Optional[Integer] = Optional.Absent,
    failureCause: Optional[String] = Optional.Absent,
    warningMessage: Optional[String] = Optional.Absent,
    sourceType: Optional[zio.aws.rds.model.ExportSourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CancelExportTaskResponse = {
    import CancelExportTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CancelExportTaskResponse
      .builder()
      .optionallyWith(
        exportTaskIdentifier.map(value => value: java.lang.String)
      )(_.exportTaskIdentifier)
      .optionallyWith(sourceArn.map(value => value: java.lang.String))(
        _.sourceArn
      )
      .optionallyWith(
        exportOnly.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exportOnly)
      .optionallyWith(snapshotTime.map(value => TStamp.unwrap(value): Instant))(
        _.snapshotTime
      )
      .optionallyWith(
        taskStartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.taskStartTime)
      .optionallyWith(taskEndTime.map(value => TStamp.unwrap(value): Instant))(
        _.taskEndTime
      )
      .optionallyWith(s3Bucket.map(value => value: java.lang.String))(
        _.s3Bucket
      )
      .optionallyWith(s3Prefix.map(value => value: java.lang.String))(
        _.s3Prefix
      )
      .optionallyWith(iamRoleArn.map(value => value: java.lang.String))(
        _.iamRoleArn
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(percentProgress.map(value => value: java.lang.Integer))(
        _.percentProgress
      )
      .optionallyWith(
        totalExtractedDataInGB.map(value => value: java.lang.Integer)
      )(_.totalExtractedDataInGB)
      .optionallyWith(failureCause.map(value => value: java.lang.String))(
        _.failureCause
      )
      .optionallyWith(warningMessage.map(value => value: java.lang.String))(
        _.warningMessage
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CancelExportTaskResponse.ReadOnly =
    zio.aws.rds.model.CancelExportTaskResponse.wrap(buildAwsValue())
}
object CancelExportTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CancelExportTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CancelExportTaskResponse =
      zio.aws.rds.model.CancelExportTaskResponse(
        exportTaskIdentifier.map(value => value),
        sourceArn.map(value => value),
        exportOnly.map(value => value),
        snapshotTime.map(value => value),
        taskStartTime.map(value => value),
        taskEndTime.map(value => value),
        s3Bucket.map(value => value),
        s3Prefix.map(value => value),
        iamRoleArn.map(value => value),
        kmsKeyId.map(value => value),
        status.map(value => value),
        percentProgress.map(value => value),
        totalExtractedDataInGB.map(value => value),
        failureCause.map(value => value),
        warningMessage.map(value => value),
        sourceType.map(value => value)
      )
    def exportTaskIdentifier: Optional[String]
    def sourceArn: Optional[String]
    def exportOnly: Optional[List[String]]
    def snapshotTime: Optional[TStamp]
    def taskStartTime: Optional[TStamp]
    def taskEndTime: Optional[TStamp]
    def s3Bucket: Optional[String]
    def s3Prefix: Optional[String]
    def iamRoleArn: Optional[String]
    def kmsKeyId: Optional[String]
    def status: Optional[String]
    def percentProgress: Optional[Integer]
    def totalExtractedDataInGB: Optional[Integer]
    def failureCause: Optional[String]
    def warningMessage: Optional[String]
    def sourceType: Optional[zio.aws.rds.model.ExportSourceType]
    def getExportTaskIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("exportTaskIdentifier", exportTaskIdentifier)
    def getSourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getExportOnly: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("exportOnly", exportOnly)
    def getSnapshotTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotTime", snapshotTime)
    def getTaskStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("taskStartTime", taskStartTime)
    def getTaskEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("taskEndTime", taskEndTime)
    def getS3Bucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
    def getIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPercentProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getTotalExtractedDataInGB: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("totalExtractedDataInGB", totalExtractedDataInGB)
    def getFailureCause: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCause", failureCause)
    def getWarningMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("warningMessage", warningMessage)
    def getSourceType: ZIO[Any, AwsError, zio.aws.rds.model.ExportSourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CancelExportTaskResponse
  ) extends zio.aws.rds.model.CancelExportTaskResponse.ReadOnly {
    override val exportTaskIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.exportTaskIdentifier())
      .map(value => value: String)
    override val sourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => value: String)
    override val exportOnly: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.exportOnly())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val snapshotTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val taskStartTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.taskStartTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val taskEndTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.taskEndTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val s3Bucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => value: String)
    override val s3Prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Prefix())
      .map(value => value: String)
    override val iamRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => value: String)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val percentProgress: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.percentProgress())
      .map(value => value: Integer)
    override val totalExtractedDataInGB: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalExtractedDataInGB())
        .map(value => value: Integer)
    override val failureCause: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCause())
      .map(value => value: String)
    override val warningMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.warningMessage())
      .map(value => value: String)
    override val sourceType: Optional[zio.aws.rds.model.ExportSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.rds.model.ExportSourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CancelExportTaskResponse
  ): zio.aws.rds.model.CancelExportTaskResponse.ReadOnly = new Wrapper(impl)
}
