package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait ActivityStreamPolicyStatus {
  def unwrap
      : software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus
}
object ActivityStreamPolicyStatus {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus
  ): zio.aws.rds.model.ActivityStreamPolicyStatus = value match {
    case software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus.LOCKED =>
      val r = locked
      r
    case software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus.UNLOCKED =>
      val r = unlocked
      r
    case software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus.LOCKING_POLICY =>
      val r = `locking-policy`
      r
    case software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus.UNLOCKING_POLICY =>
      val r = `unlocking-policy`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rds.model.ActivityStreamPolicyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus =
      software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object locked extends zio.aws.rds.model.ActivityStreamPolicyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus =
      software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus.LOCKED
  }
  case object unlocked extends zio.aws.rds.model.ActivityStreamPolicyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus =
      software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus.UNLOCKED
  }
  case object `locking-policy`
      extends zio.aws.rds.model.ActivityStreamPolicyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus =
      software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus.LOCKING_POLICY
  }
  case object `unlocking-policy`
      extends zio.aws.rds.model.ActivityStreamPolicyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus =
      software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus.UNLOCKING_POLICY
  }
}
