package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidStorageOptions(
    storageType: Optional[String] = Optional.Absent,
    storageSize: Optional[Iterable[zio.aws.rds.model.Range]] = Optional.Absent,
    provisionedIops: Optional[Iterable[zio.aws.rds.model.Range]] =
      Optional.Absent,
    iopsToStorageRatio: Optional[Iterable[zio.aws.rds.model.DoubleRange]] =
      Optional.Absent,
    supportsStorageAutoscaling: Optional[Boolean] = Optional.Absent,
    provisionedStorageThroughput: Optional[Iterable[zio.aws.rds.model.Range]] =
      Optional.Absent,
    storageThroughputToIopsRatio: Optional[
      Iterable[zio.aws.rds.model.DoubleRange]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ValidStorageOptions = {
    import ValidStorageOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ValidStorageOptions
      .builder()
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        storageSize.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageSize)
      .optionallyWith(
        provisionedIops.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedIops)
      .optionallyWith(
        iopsToStorageRatio.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.iopsToStorageRatio)
      .optionallyWith(
        supportsStorageAutoscaling.map(value => value: java.lang.Boolean)
      )(_.supportsStorageAutoscaling)
      .optionallyWith(
        provisionedStorageThroughput.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedStorageThroughput)
      .optionallyWith(
        storageThroughputToIopsRatio.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageThroughputToIopsRatio)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ValidStorageOptions.ReadOnly =
    zio.aws.rds.model.ValidStorageOptions.wrap(buildAwsValue())
}
object ValidStorageOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ValidStorageOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ValidStorageOptions =
      zio.aws.rds.model.ValidStorageOptions(
        storageType.map(value => value),
        storageSize.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisionedIops.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        iopsToStorageRatio.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportsStorageAutoscaling.map(value => value),
        provisionedStorageThroughput.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageThroughputToIopsRatio.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def storageType: Optional[String]
    def storageSize: Optional[List[zio.aws.rds.model.Range.ReadOnly]]
    def provisionedIops: Optional[List[zio.aws.rds.model.Range.ReadOnly]]
    def iopsToStorageRatio
        : Optional[List[zio.aws.rds.model.DoubleRange.ReadOnly]]
    def supportsStorageAutoscaling: Optional[Boolean]
    def provisionedStorageThroughput
        : Optional[List[zio.aws.rds.model.Range.ReadOnly]]
    def storageThroughputToIopsRatio
        : Optional[List[zio.aws.rds.model.DoubleRange.ReadOnly]]
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getStorageSize
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("storageSize", storageSize)
    def getProvisionedIops
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("provisionedIops", provisionedIops)
    def getIopsToStorageRatio
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DoubleRange.ReadOnly]] =
      AwsError.unwrapOptionField("iopsToStorageRatio", iopsToStorageRatio)
    def getSupportsStorageAutoscaling: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsStorageAutoscaling",
        supportsStorageAutoscaling
      )
    def getProvisionedStorageThroughput
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField(
        "provisionedStorageThroughput",
        provisionedStorageThroughput
      )
    def getStorageThroughputToIopsRatio
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DoubleRange.ReadOnly]] =
      AwsError.unwrapOptionField(
        "storageThroughputToIopsRatio",
        storageThroughputToIopsRatio
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ValidStorageOptions
  ) extends zio.aws.rds.model.ValidStorageOptions.ReadOnly {
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val storageSize: Optional[List[zio.aws.rds.model.Range.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageSize())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Range.wrap(item)
          }.toList
        )
    override val provisionedIops
        : Optional[List[zio.aws.rds.model.Range.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedIops())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Range.wrap(item)
          }.toList
        )
    override val iopsToStorageRatio
        : Optional[List[zio.aws.rds.model.DoubleRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iopsToStorageRatio())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DoubleRange.wrap(item)
          }.toList
        )
    override val supportsStorageAutoscaling: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsStorageAutoscaling())
        .map(value => value: Boolean)
    override val provisionedStorageThroughput
        : Optional[List[zio.aws.rds.model.Range.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedStorageThroughput())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Range.wrap(item)
          }.toList
        )
    override val storageThroughputToIopsRatio
        : Optional[List[zio.aws.rds.model.DoubleRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageThroughputToIopsRatio())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DoubleRange.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ValidStorageOptions
  ): zio.aws.rds.model.ValidStorageOptions.ReadOnly = new Wrapper(impl)
}
