package zio.aws.rds.model
import zio.aws.rds.model.primitives.{SwitchoverDetailStatus, DatabaseArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SwitchoverDetail(
    sourceMember: Optional[DatabaseArn] = Optional.Absent,
    targetMember: Optional[DatabaseArn] = Optional.Absent,
    status: Optional[SwitchoverDetailStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.SwitchoverDetail = {
    import SwitchoverDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.SwitchoverDetail
      .builder()
      .optionallyWith(
        sourceMember.map(value => DatabaseArn.unwrap(value): java.lang.String)
      )(_.sourceMember)
      .optionallyWith(
        targetMember.map(value => DatabaseArn.unwrap(value): java.lang.String)
      )(_.targetMember)
      .optionallyWith(
        status.map(value =>
          SwitchoverDetailStatus.unwrap(value): java.lang.String
        )
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.SwitchoverDetail.ReadOnly =
    zio.aws.rds.model.SwitchoverDetail.wrap(buildAwsValue())
}
object SwitchoverDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.SwitchoverDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.SwitchoverDetail =
      zio.aws.rds.model.SwitchoverDetail(
        sourceMember.map(value => value),
        targetMember.map(value => value),
        status.map(value => value)
      )
    def sourceMember: Optional[DatabaseArn]
    def targetMember: Optional[DatabaseArn]
    def status: Optional[SwitchoverDetailStatus]
    def getSourceMember: ZIO[Any, AwsError, DatabaseArn] =
      AwsError.unwrapOptionField("sourceMember", sourceMember)
    def getTargetMember: ZIO[Any, AwsError, DatabaseArn] =
      AwsError.unwrapOptionField("targetMember", targetMember)
    def getStatus: ZIO[Any, AwsError, SwitchoverDetailStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.SwitchoverDetail
  ) extends zio.aws.rds.model.SwitchoverDetail.ReadOnly {
    override val sourceMember: Optional[DatabaseArn] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceMember())
      .map(value => zio.aws.rds.model.primitives.DatabaseArn(value))
    override val targetMember: Optional[DatabaseArn] = zio.aws.core.internal
      .optionalFromNullable(impl.targetMember())
      .map(value => zio.aws.rds.model.primitives.DatabaseArn(value))
    override val status: Optional[SwitchoverDetailStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.rds.model.primitives.SwitchoverDetailStatus(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.SwitchoverDetail
  ): zio.aws.rds.model.SwitchoverDetail.ReadOnly = new Wrapper(impl)
}
