package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Filter(name: String, values: Iterable[String]) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Filter
      .builder()
      .name(name: java.lang.String)
      .values(values.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Filter.ReadOnly =
    zio.aws.rds.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Filter =
      zio.aws.rds.model.Filter(name, values)
    def name: String
    def values: List[String]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[String]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Filter
  ) extends zio.aws.rds.model.Filter.ReadOnly {
    override val name: String = impl.name(): String
    override val values: List[String] = impl
      .values()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Filter
  ): zio.aws.rds.model.Filter.ReadOnly = new Wrapper(impl)
}
