package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBlueGreenDeploymentResponse(
    blueGreenDeployment: Optional[zio.aws.rds.model.BlueGreenDeployment] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentResponse = {
    import DeleteBlueGreenDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentResponse
      .builder()
      .optionallyWith(blueGreenDeployment.map(value => value.buildAwsValue()))(
        _.blueGreenDeployment
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteBlueGreenDeploymentResponse.ReadOnly =
    zio.aws.rds.model.DeleteBlueGreenDeploymentResponse.wrap(buildAwsValue())
}
object DeleteBlueGreenDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteBlueGreenDeploymentResponse =
      zio.aws.rds.model.DeleteBlueGreenDeploymentResponse(
        blueGreenDeployment.map(value => value.asEditable)
      )
    def blueGreenDeployment
        : Optional[zio.aws.rds.model.BlueGreenDeployment.ReadOnly]
    def getBlueGreenDeployment
        : ZIO[Any, AwsError, zio.aws.rds.model.BlueGreenDeployment.ReadOnly] =
      AwsError.unwrapOptionField("blueGreenDeployment", blueGreenDeployment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentResponse
  ) extends zio.aws.rds.model.DeleteBlueGreenDeploymentResponse.ReadOnly {
    override val blueGreenDeployment
        : Optional[zio.aws.rds.model.BlueGreenDeployment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blueGreenDeployment())
        .map(value => zio.aws.rds.model.BlueGreenDeployment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentResponse
  ): zio.aws.rds.model.DeleteBlueGreenDeploymentResponse.ReadOnly = new Wrapper(
    impl
  )
}
