package zio.aws.rds.model
import zio.aws.rds.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DBProxyTarget(
    targetArn: Optional[String] = Optional.Absent,
    endpoint: Optional[String] = Optional.Absent,
    trackedClusterId: Optional[String] = Optional.Absent,
    rdsResourceId: Optional[String] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    `type`: Optional[zio.aws.rds.model.TargetType] = Optional.Absent,
    role: Optional[zio.aws.rds.model.TargetRole] = Optional.Absent,
    targetHealth: Optional[zio.aws.rds.model.TargetHealth] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBProxyTarget = {
    import DBProxyTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBProxyTarget
      .builder()
      .optionallyWith(targetArn.map(value => value: java.lang.String))(
        _.targetArn
      )
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(trackedClusterId.map(value => value: java.lang.String))(
        _.trackedClusterId
      )
      .optionallyWith(rdsResourceId.map(value => value: java.lang.String))(
        _.rdsResourceId
      )
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(role.map(value => value.unwrap))(_.role)
      .optionallyWith(targetHealth.map(value => value.buildAwsValue()))(
        _.targetHealth
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBProxyTarget.ReadOnly =
    zio.aws.rds.model.DBProxyTarget.wrap(buildAwsValue())
}
object DBProxyTarget {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBProxyTarget] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBProxyTarget =
      zio.aws.rds.model.DBProxyTarget(
        targetArn.map(value => value),
        endpoint.map(value => value),
        trackedClusterId.map(value => value),
        rdsResourceId.map(value => value),
        port.map(value => value),
        `type`.map(value => value),
        role.map(value => value),
        targetHealth.map(value => value.asEditable)
      )
    def targetArn: Optional[String]
    def endpoint: Optional[String]
    def trackedClusterId: Optional[String]
    def rdsResourceId: Optional[String]
    def port: Optional[Integer]
    def `type`: Optional[zio.aws.rds.model.TargetType]
    def role: Optional[zio.aws.rds.model.TargetRole]
    def targetHealth: Optional[zio.aws.rds.model.TargetHealth.ReadOnly]
    def getTargetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getTrackedClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trackedClusterId", trackedClusterId)
    def getRdsResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rdsResourceId", rdsResourceId)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getType: ZIO[Any, AwsError, zio.aws.rds.model.TargetType] =
      AwsError.unwrapOptionField("type", `type`)
    def getRole: ZIO[Any, AwsError, zio.aws.rds.model.TargetRole] =
      AwsError.unwrapOptionField("role", role)
    def getTargetHealth
        : ZIO[Any, AwsError, zio.aws.rds.model.TargetHealth.ReadOnly] =
      AwsError.unwrapOptionField("targetHealth", targetHealth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBProxyTarget
  ) extends zio.aws.rds.model.DBProxyTarget.ReadOnly {
    override val targetArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => value: String)
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val trackedClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.trackedClusterId())
      .map(value => value: String)
    override val rdsResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rdsResourceId())
      .map(value => value: String)
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val `type`: Optional[zio.aws.rds.model.TargetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.rds.model.TargetType.wrap(value))
    override val role: Optional[zio.aws.rds.model.TargetRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.role())
        .map(value => zio.aws.rds.model.TargetRole.wrap(value))
    override val targetHealth
        : Optional[zio.aws.rds.model.TargetHealth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetHealth())
        .map(value => zio.aws.rds.model.TargetHealth.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBProxyTarget
  ): zio.aws.rds.model.DBProxyTarget.ReadOnly = new Wrapper(impl)
}
