package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{IntegerOptional, TStamp, Integer}
import scala.jdk.CollectionConverters._
final case class DBInstanceAutomatedBackup(
    dbInstanceArn: Optional[String] = Optional.Absent,
    dbiResourceId: Optional[String] = Optional.Absent,
    region: Optional[String] = Optional.Absent,
    dbInstanceIdentifier: Optional[String] = Optional.Absent,
    restoreWindow: Optional[zio.aws.rds.model.RestoreWindow] = Optional.Absent,
    allocatedStorage: Optional[Integer] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    instanceCreateTime: Optional[TStamp] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    tdeCredentialArn: Optional[String] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    timezone: Optional[String] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[Boolean] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    dbInstanceAutomatedBackupsArn: Optional[String] = Optional.Absent,
    dbInstanceAutomatedBackupsReplications: Optional[
      Iterable[zio.aws.rds.model.DBInstanceAutomatedBackupsReplication]
    ] = Optional.Absent,
    backupTarget: Optional[String] = Optional.Absent,
    storageThroughput: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup = {
    import DBInstanceAutomatedBackup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup
      .builder()
      .optionallyWith(dbInstanceArn.map(value => value: java.lang.String))(
        _.dbInstanceArn
      )
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(restoreWindow.map(value => value.buildAwsValue()))(
        _.restoreWindow
      )
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        instanceCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.instanceCreateTime)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        backupRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.backupRetentionPeriod)
      .optionallyWith(
        dbInstanceAutomatedBackupsArn.map(value => value: java.lang.String)
      )(_.dbInstanceAutomatedBackupsArn)
      .optionallyWith(
        dbInstanceAutomatedBackupsReplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbInstanceAutomatedBackupsReplications)
      .optionallyWith(backupTarget.map(value => value: java.lang.String))(
        _.backupTarget
      )
      .optionallyWith(storageThroughput.map(value => value: java.lang.Integer))(
        _.storageThroughput
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly =
    zio.aws.rds.model.DBInstanceAutomatedBackup.wrap(buildAwsValue())
}
object DBInstanceAutomatedBackup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBInstanceAutomatedBackup =
      zio.aws.rds.model.DBInstanceAutomatedBackup(
        dbInstanceArn.map(value => value),
        dbiResourceId.map(value => value),
        region.map(value => value),
        dbInstanceIdentifier.map(value => value),
        restoreWindow.map(value => value.asEditable),
        allocatedStorage.map(value => value),
        status.map(value => value),
        port.map(value => value),
        availabilityZone.map(value => value),
        vpcId.map(value => value),
        instanceCreateTime.map(value => value),
        masterUsername.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        tdeCredentialArn.map(value => value),
        encrypted.map(value => value),
        storageType.map(value => value),
        kmsKeyId.map(value => value),
        timezone.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbInstanceAutomatedBackupsArn.map(value => value),
        dbInstanceAutomatedBackupsReplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        backupTarget.map(value => value),
        storageThroughput.map(value => value)
      )
    def dbInstanceArn: Optional[String]
    def dbiResourceId: Optional[String]
    def region: Optional[String]
    def dbInstanceIdentifier: Optional[String]
    def restoreWindow: Optional[zio.aws.rds.model.RestoreWindow.ReadOnly]
    def allocatedStorage: Optional[Integer]
    def status: Optional[String]
    def port: Optional[Integer]
    def availabilityZone: Optional[String]
    def vpcId: Optional[String]
    def instanceCreateTime: Optional[TStamp]
    def masterUsername: Optional[String]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def licenseModel: Optional[String]
    def iops: Optional[IntegerOptional]
    def optionGroupName: Optional[String]
    def tdeCredentialArn: Optional[String]
    def encrypted: Optional[Boolean]
    def storageType: Optional[String]
    def kmsKeyId: Optional[String]
    def timezone: Optional[String]
    def iamDatabaseAuthenticationEnabled: Optional[Boolean]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def dbInstanceAutomatedBackupsArn: Optional[String]
    def dbInstanceAutomatedBackupsReplications: Optional[
      List[zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly]
    ]
    def backupTarget: Optional[String]
    def storageThroughput: Optional[IntegerOptional]
    def getDbInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceArn", dbInstanceArn)
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getRestoreWindow
        : ZIO[Any, AwsError, zio.aws.rds.model.RestoreWindow.ReadOnly] =
      AwsError.unwrapOptionField("restoreWindow", restoreWindow)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getInstanceCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbInstanceAutomatedBackupsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbInstanceAutomatedBackupsArn",
        dbInstanceAutomatedBackupsArn
      )
    def getDbInstanceAutomatedBackupsReplications: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbInstanceAutomatedBackupsReplications",
      dbInstanceAutomatedBackupsReplications
    )
    def getBackupTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupTarget", backupTarget)
    def getStorageThroughput: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("storageThroughput", storageThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup
  ) extends zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly {
    override val dbInstanceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceArn())
      .map(value => value: String)
    override val dbiResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbiResourceId())
      .map(value => value: String)
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
    override val dbInstanceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceIdentifier())
      .map(value => value: String)
    override val restoreWindow
        : Optional[zio.aws.rds.model.RestoreWindow.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreWindow())
        .map(value => zio.aws.rds.model.RestoreWindow.wrap(value))
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val instanceCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val tdeCredentialArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tdeCredentialArn())
      .map(value => value: String)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val timezone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: Boolean)
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val dbInstanceAutomatedBackupsArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceAutomatedBackupsArn())
        .map(value => value: String)
    override val dbInstanceAutomatedBackupsReplications: Optional[
      List[zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceAutomatedBackupsReplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.wrap(item)
        }.toList
      )
    override val backupTarget: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupTarget())
      .map(value => value: String)
    override val storageThroughput: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageThroughput())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup
  ): zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly = new Wrapper(impl)
}
