package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbSubnetGroupResponse(
    dbSubnetGroup: Optional[zio.aws.rds.model.DBSubnetGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse = {
    import CreateDbSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse
      .builder()
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbSubnetGroupResponse.ReadOnly =
    zio.aws.rds.model.CreateDbSubnetGroupResponse.wrap(buildAwsValue())
}
object CreateDbSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbSubnetGroupResponse =
      zio.aws.rds.model.CreateDbSubnetGroupResponse(
        dbSubnetGroup.map(value => value.asEditable)
      )
    def dbSubnetGroup: Optional[zio.aws.rds.model.DBSubnetGroup.ReadOnly]
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.rds.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse
  ) extends zio.aws.rds.model.CreateDbSubnetGroupResponse.ReadOnly {
    override val dbSubnetGroup
        : Optional[zio.aws.rds.model.DBSubnetGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroup())
        .map(value => zio.aws.rds.model.DBSubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse
  ): zio.aws.rds.model.CreateDbSubnetGroupResponse.ReadOnly = new Wrapper(impl)
}
