package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbProxyResponse(
    dbProxy: Optional[zio.aws.rds.model.DBProxy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbProxyResponse = {
    import CreateDbProxyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbProxyResponse
      .builder()
      .optionallyWith(dbProxy.map(value => value.buildAwsValue()))(_.dbProxy)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbProxyResponse.ReadOnly =
    zio.aws.rds.model.CreateDbProxyResponse.wrap(buildAwsValue())
}
object CreateDbProxyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbProxyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbProxyResponse = zio.aws.rds.model
      .CreateDbProxyResponse(dbProxy.map(value => value.asEditable))
    def dbProxy: Optional[zio.aws.rds.model.DBProxy.ReadOnly]
    def getDbProxy: ZIO[Any, AwsError, zio.aws.rds.model.DBProxy.ReadOnly] =
      AwsError.unwrapOptionField("dbProxy", dbProxy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbProxyResponse
  ) extends zio.aws.rds.model.CreateDbProxyResponse.ReadOnly {
    override val dbProxy: Optional[zio.aws.rds.model.DBProxy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbProxy())
        .map(value => zio.aws.rds.model.DBProxy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbProxyResponse
  ): zio.aws.rds.model.CreateDbProxyResponse.ReadOnly = new Wrapper(impl)
}
