package zio.aws.rds.model
import zio.aws.rds.model.primitives.{
  Description,
  BucketName,
  String255,
  CustomEngineVersion,
  CustomEngineName,
  KmsKeyIdOrArn,
  CustomDBEngineVersionManifest
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCustomDbEngineVersionRequest(
    engine: CustomEngineName,
    engineVersion: CustomEngineVersion,
    databaseInstallationFilesS3BucketName: Optional[BucketName] =
      Optional.Absent,
    databaseInstallationFilesS3Prefix: Optional[String255] = Optional.Absent,
    imageId: Optional[String255] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyIdOrArn] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    manifest: Optional[CustomDBEngineVersionManifest] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest = {
    import CreateCustomDbEngineVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest
      .builder()
      .engine(CustomEngineName.unwrap(engine): java.lang.String)
      .engineVersion(
        CustomEngineVersion.unwrap(engineVersion): java.lang.String
      )
      .optionallyWith(
        databaseInstallationFilesS3BucketName.map(value =>
          BucketName.unwrap(value): java.lang.String
        )
      )(_.databaseInstallationFilesS3BucketName)
      .optionallyWith(
        databaseInstallationFilesS3Prefix.map(value =>
          String255.unwrap(value): java.lang.String
        )
      )(_.databaseInstallationFilesS3Prefix)
      .optionallyWith(
        imageId.map(value => String255.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyIdOrArn.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        manifest.map(value =>
          CustomDBEngineVersionManifest.unwrap(value): java.lang.String
        )
      )(_.manifest)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.CreateCustomDbEngineVersionRequest.ReadOnly =
    zio.aws.rds.model.CreateCustomDbEngineVersionRequest.wrap(buildAwsValue())
}
object CreateCustomDbEngineVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateCustomDbEngineVersionRequest =
      zio.aws.rds.model.CreateCustomDbEngineVersionRequest(
        engine,
        engineVersion,
        databaseInstallationFilesS3BucketName.map(value => value),
        databaseInstallationFilesS3Prefix.map(value => value),
        imageId.map(value => value),
        kmsKeyId.map(value => value),
        description.map(value => value),
        manifest.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def engine: CustomEngineName
    def engineVersion: CustomEngineVersion
    def databaseInstallationFilesS3BucketName: Optional[BucketName]
    def databaseInstallationFilesS3Prefix: Optional[String255]
    def imageId: Optional[String255]
    def kmsKeyId: Optional[KmsKeyIdOrArn]
    def description: Optional[Description]
    def manifest: Optional[CustomDBEngineVersionManifest]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getEngine: ZIO[Any, Nothing, CustomEngineName] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, Nothing, CustomEngineVersion] =
      ZIO.succeed(engineVersion)
    def getDatabaseInstallationFilesS3BucketName
        : ZIO[Any, AwsError, BucketName] = AwsError.unwrapOptionField(
      "databaseInstallationFilesS3BucketName",
      databaseInstallationFilesS3BucketName
    )
    def getDatabaseInstallationFilesS3Prefix: ZIO[Any, AwsError, String255] =
      AwsError.unwrapOptionField(
        "databaseInstallationFilesS3Prefix",
        databaseInstallationFilesS3Prefix
      )
    def getImageId: ZIO[Any, AwsError, String255] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyIdOrArn] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getManifest: ZIO[Any, AwsError, CustomDBEngineVersionManifest] =
      AwsError.unwrapOptionField("manifest", manifest)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest
  ) extends zio.aws.rds.model.CreateCustomDbEngineVersionRequest.ReadOnly {
    override val engine: CustomEngineName =
      zio.aws.rds.model.primitives.CustomEngineName(impl.engine())
    override val engineVersion: CustomEngineVersion =
      zio.aws.rds.model.primitives.CustomEngineVersion(impl.engineVersion())
    override val databaseInstallationFilesS3BucketName: Optional[BucketName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseInstallationFilesS3BucketName())
        .map(value => zio.aws.rds.model.primitives.BucketName(value))
    override val databaseInstallationFilesS3Prefix: Optional[String255] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseInstallationFilesS3Prefix())
        .map(value => zio.aws.rds.model.primitives.String255(value))
    override val imageId: Optional[String255] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.rds.model.primitives.String255(value))
    override val kmsKeyId: Optional[KmsKeyIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.rds.model.primitives.KmsKeyIdOrArn(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.rds.model.primitives.Description(value))
    override val manifest: Optional[CustomDBEngineVersionManifest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifest())
        .map(value =>
          zio.aws.rds.model.primitives.CustomDBEngineVersionManifest(value)
        )
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest
  ): zio.aws.rds.model.CreateCustomDbEngineVersionRequest.ReadOnly =
    new Wrapper(impl)
}
