package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyDbSnapshotRequest(
    sourceDBSnapshotIdentifier: String,
    targetDBSnapshotIdentifier: String,
    kmsKeyId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    copyTags: Optional[BooleanOptional] = Optional.Absent,
    preSignedUrl: Optional[String] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    targetCustomAvailabilityZone: Optional[String] = Optional.Absent,
    copyOptionGroup: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest = {
    import CopyDbSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest
      .builder()
      .sourceDBSnapshotIdentifier(sourceDBSnapshotIdentifier: java.lang.String)
      .targetDBSnapshotIdentifier(targetDBSnapshotIdentifier: java.lang.String)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(copyTags.map(value => value: java.lang.Boolean))(
        _.copyTags
      )
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        targetCustomAvailabilityZone.map(value => value: java.lang.String)
      )(_.targetCustomAvailabilityZone)
      .optionallyWith(copyOptionGroup.map(value => value: java.lang.Boolean))(
        _.copyOptionGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CopyDbSnapshotRequest.ReadOnly =
    zio.aws.rds.model.CopyDbSnapshotRequest.wrap(buildAwsValue())
}
object CopyDbSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CopyDbSnapshotRequest =
      zio.aws.rds.model.CopyDbSnapshotRequest(
        sourceDBSnapshotIdentifier,
        targetDBSnapshotIdentifier,
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        copyTags.map(value => value),
        preSignedUrl.map(value => value),
        optionGroupName.map(value => value),
        targetCustomAvailabilityZone.map(value => value),
        copyOptionGroup.map(value => value)
      )
    def sourceDBSnapshotIdentifier: String
    def targetDBSnapshotIdentifier: String
    def kmsKeyId: Optional[String]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def copyTags: Optional[BooleanOptional]
    def preSignedUrl: Optional[String]
    def optionGroupName: Optional[String]
    def targetCustomAvailabilityZone: Optional[String]
    def copyOptionGroup: Optional[BooleanOptional]
    def getSourceDBSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBSnapshotIdentifier)
    def getTargetDBSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBSnapshotIdentifier)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCopyTags: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getTargetCustomAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetCustomAvailabilityZone",
        targetCustomAvailabilityZone
      )
    def getCopyOptionGroup: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyOptionGroup", copyOptionGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest
  ) extends zio.aws.rds.model.CopyDbSnapshotRequest.ReadOnly {
    override val sourceDBSnapshotIdentifier: String =
      impl.sourceDBSnapshotIdentifier(): String
    override val targetDBSnapshotIdentifier: String =
      impl.targetDBSnapshotIdentifier(): String
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val copyTags: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTags())
      .map(value => value: BooleanOptional)
    override val preSignedUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preSignedUrl())
      .map(value => value: String)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val targetCustomAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetCustomAvailabilityZone())
        .map(value => value: String)
    override val copyOptionGroup: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyOptionGroup())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest
  ): zio.aws.rds.model.CopyDbSnapshotRequest.ReadOnly = new Wrapper(impl)
}
