package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait ClientPasswordAuthType {
  def unwrap: software.amazon.awssdk.services.rds.model.ClientPasswordAuthType
}
object ClientPasswordAuthType {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.ClientPasswordAuthType
  ): zio.aws.rds.model.ClientPasswordAuthType = value match {
    case software.amazon.awssdk.services.rds.model.ClientPasswordAuthType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.ClientPasswordAuthType.MYSQL_NATIVE_PASSWORD =>
      val r = MYSQL_NATIVE_PASSWORD
      r
    case software.amazon.awssdk.services.rds.model.ClientPasswordAuthType.POSTGRES_SCRAM_SHA_256 =>
      val r = POSTGRES_SCRAM_SHA_256
      r
    case software.amazon.awssdk.services.rds.model.ClientPasswordAuthType.POSTGRES_MD5 =>
      val r = POSTGRES_MD5
      r
    case software.amazon.awssdk.services.rds.model.ClientPasswordAuthType.SQL_SERVER_AUTHENTICATION =>
      val r = SQL_SERVER_AUTHENTICATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rds.model.ClientPasswordAuthType {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ClientPasswordAuthType =
      software.amazon.awssdk.services.rds.model.ClientPasswordAuthType.UNKNOWN_TO_SDK_VERSION
  }
  case object MYSQL_NATIVE_PASSWORD
      extends zio.aws.rds.model.ClientPasswordAuthType {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ClientPasswordAuthType =
      software.amazon.awssdk.services.rds.model.ClientPasswordAuthType.MYSQL_NATIVE_PASSWORD
  }
  case object POSTGRES_SCRAM_SHA_256
      extends zio.aws.rds.model.ClientPasswordAuthType {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ClientPasswordAuthType =
      software.amazon.awssdk.services.rds.model.ClientPasswordAuthType.POSTGRES_SCRAM_SHA_256
  }
  case object POSTGRES_MD5 extends zio.aws.rds.model.ClientPasswordAuthType {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ClientPasswordAuthType =
      software.amazon.awssdk.services.rds.model.ClientPasswordAuthType.POSTGRES_MD5
  }
  case object SQL_SERVER_AUTHENTICATION
      extends zio.aws.rds.model.ClientPasswordAuthType {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ClientPasswordAuthType =
      software.amazon.awssdk.services.rds.model.ClientPasswordAuthType.SQL_SERVER_AUTHENTICATION
  }
}
