package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AvailableProcessorFeature(
    name: Optional[String] = Optional.Absent,
    defaultValue: Optional[String] = Optional.Absent,
    allowedValues: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.AvailableProcessorFeature = {
    import AvailableProcessorFeature.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.AvailableProcessorFeature
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.AvailableProcessorFeature.ReadOnly =
    zio.aws.rds.model.AvailableProcessorFeature.wrap(buildAwsValue())
}
object AvailableProcessorFeature {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.AvailableProcessorFeature
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.AvailableProcessorFeature =
      zio.aws.rds.model.AvailableProcessorFeature(
        name.map(value => value),
        defaultValue.map(value => value),
        allowedValues.map(value => value)
      )
    def name: Optional[String]
    def defaultValue: Optional[String]
    def allowedValues: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.AvailableProcessorFeature
  ) extends zio.aws.rds.model.AvailableProcessorFeature.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val defaultValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: String)
    override val allowedValues: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedValues())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.AvailableProcessorFeature
  ): zio.aws.rds.model.AvailableProcessorFeature.ReadOnly = new Wrapper(impl)
}
