package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait AuditPolicyState {
  def unwrap: software.amazon.awssdk.services.rds.model.AuditPolicyState
}
object AuditPolicyState {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.AuditPolicyState
  ): zio.aws.rds.model.AuditPolicyState = value match {
    case software.amazon.awssdk.services.rds.model.AuditPolicyState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.AuditPolicyState.LOCKED =>
      val r = locked
      r
    case software.amazon.awssdk.services.rds.model.AuditPolicyState.UNLOCKED =>
      val r = unlocked
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.AuditPolicyState {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.AuditPolicyState =
      software.amazon.awssdk.services.rds.model.AuditPolicyState.UNKNOWN_TO_SDK_VERSION
  }
  case object locked extends zio.aws.rds.model.AuditPolicyState {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.AuditPolicyState =
      software.amazon.awssdk.services.rds.model.AuditPolicyState.LOCKED
  }
  case object unlocked extends zio.aws.rds.model.AuditPolicyState {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.AuditPolicyState =
      software.amazon.awssdk.services.rds.model.AuditPolicyState.UNLOCKED
  }
}
