package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SourceRegion(
    regionName: Optional[String] = Optional.Absent,
    endpoint: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    supportsDBInstanceAutomatedBackupsReplication: Optional[Boolean] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.SourceRegion = {
    import SourceRegion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.SourceRegion
      .builder()
      .optionallyWith(regionName.map(value => value: java.lang.String))(
        _.regionName
      )
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        supportsDBInstanceAutomatedBackupsReplication.map(value =>
          value: java.lang.Boolean
        )
      )(_.supportsDBInstanceAutomatedBackupsReplication)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.SourceRegion.ReadOnly =
    zio.aws.rds.model.SourceRegion.wrap(buildAwsValue())
}
object SourceRegion {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.SourceRegion] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.SourceRegion =
      zio.aws.rds.model.SourceRegion(
        regionName.map(value => value),
        endpoint.map(value => value),
        status.map(value => value),
        supportsDBInstanceAutomatedBackupsReplication.map(value => value)
      )
    def regionName: Optional[String]
    def endpoint: Optional[String]
    def status: Optional[String]
    def supportsDBInstanceAutomatedBackupsReplication: Optional[Boolean]
    def getRegionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSupportsDBInstanceAutomatedBackupsReplication
        : ZIO[Any, AwsError, Boolean] = AwsError.unwrapOptionField(
      "supportsDBInstanceAutomatedBackupsReplication",
      supportsDBInstanceAutomatedBackupsReplication
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.SourceRegion
  ) extends zio.aws.rds.model.SourceRegion.ReadOnly {
    override val regionName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.regionName())
      .map(value => value: String)
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val supportsDBInstanceAutomatedBackupsReplication
        : Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(
        impl.supportsDBInstanceAutomatedBackupsReplication()
      )
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.SourceRegion
  ): zio.aws.rds.model.SourceRegion.ReadOnly = new Wrapper(impl)
}
