package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IPRange(
    status: Optional[String] = Optional.Absent,
    cidrip: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.IPRange = {
    import IPRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.IPRange
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(cidrip.map(value => value: java.lang.String))(_.cidrip)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.IPRange.ReadOnly =
    zio.aws.rds.model.IPRange.wrap(buildAwsValue())
}
object IPRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.IPRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.IPRange = zio.aws.rds.model
      .IPRange(status.map(value => value), cidrip.map(value => value))
    def status: Optional[String]
    def cidrip: Optional[String]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getCidrip: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrip", cidrip)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.IPRange
  ) extends zio.aws.rds.model.IPRange.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val cidrip: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrip())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.IPRange
  ): zio.aws.rds.model.IPRange.ReadOnly = new Wrapper(impl)
}
