package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait FailoverStatus {
  def unwrap: software.amazon.awssdk.services.rds.model.FailoverStatus
}
object FailoverStatus {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.FailoverStatus
  ): zio.aws.rds.model.FailoverStatus = value match {
    case software.amazon.awssdk.services.rds.model.FailoverStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.FailoverStatus.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.rds.model.FailoverStatus.FAILING_OVER =>
      val r = `failing-over`
      r
    case software.amazon.awssdk.services.rds.model.FailoverStatus.CANCELLING =>
      val r = cancelling
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.FailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.FailoverStatus =
      software.amazon.awssdk.services.rds.model.FailoverStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.rds.model.FailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.FailoverStatus =
      software.amazon.awssdk.services.rds.model.FailoverStatus.PENDING
  }
  case object `failing-over` extends zio.aws.rds.model.FailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.FailoverStatus =
      software.amazon.awssdk.services.rds.model.FailoverStatus.FAILING_OVER
  }
  case object cancelling extends zio.aws.rds.model.FailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.FailoverStatus =
      software.amazon.awssdk.services.rds.model.FailoverStatus.CANCELLING
  }
}
