package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEngineDefaultClusterParametersResponse(
    engineDefaults: Optional[zio.aws.rds.model.EngineDefaults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse = {
    import DescribeEngineDefaultClusterParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse
      .builder()
      .optionallyWith(engineDefaults.map(value => value.buildAwsValue()))(
        _.engineDefaults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly =
    zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse
      .wrap(buildAwsValue())
}
object DescribeEngineDefaultClusterParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse =
      zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse(
        engineDefaults.map(value => value.asEditable)
      )
    def engineDefaults: Optional[zio.aws.rds.model.EngineDefaults.ReadOnly]
    def getEngineDefaults
        : ZIO[Any, AwsError, zio.aws.rds.model.EngineDefaults.ReadOnly] =
      AwsError.unwrapOptionField("engineDefaults", engineDefaults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse
  ) extends zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly {
    override val engineDefaults
        : Optional[zio.aws.rds.model.EngineDefaults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineDefaults())
        .map(value => zio.aws.rds.model.EngineDefaults.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse
  ): zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly =
    new Wrapper(impl)
}
