package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DBInstanceAutomatedBackupsReplication(
    dbInstanceAutomatedBackupsArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication = {
    import DBInstanceAutomatedBackupsReplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication
      .builder()
      .optionallyWith(
        dbInstanceAutomatedBackupsArn.map(value => value: java.lang.String)
      )(_.dbInstanceAutomatedBackupsArn)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly =
    zio.aws.rds.model.DBInstanceAutomatedBackupsReplication
      .wrap(buildAwsValue())
}
object DBInstanceAutomatedBackupsReplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBInstanceAutomatedBackupsReplication =
      zio.aws.rds.model.DBInstanceAutomatedBackupsReplication(
        dbInstanceAutomatedBackupsArn.map(value => value)
      )
    def dbInstanceAutomatedBackupsArn: Optional[String]
    def getDbInstanceAutomatedBackupsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbInstanceAutomatedBackupsArn",
        dbInstanceAutomatedBackupsArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication
  ) extends zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly {
    override val dbInstanceAutomatedBackupsArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceAutomatedBackupsArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication
  ): zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly =
    new Wrapper(impl)
}
