package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartDbInstanceRequest(dbInstanceIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StartDbInstanceRequest = {
    import StartDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StartDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StartDbInstanceRequest.ReadOnly =
    zio.aws.rds.model.StartDbInstanceRequest.wrap(buildAwsValue())
}
object StartDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StartDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StartDbInstanceRequest =
      zio.aws.rds.model.StartDbInstanceRequest(dbInstanceIdentifier)
    def dbInstanceIdentifier: String
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StartDbInstanceRequest
  ) extends zio.aws.rds.model.StartDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StartDbInstanceRequest
  ): zio.aws.rds.model.StartDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
