package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RebootDbInstanceRequest(
    dbInstanceIdentifier: String,
    forceFailover: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RebootDbInstanceRequest = {
    import RebootDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RebootDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(forceFailover.map(value => value: java.lang.Boolean))(
        _.forceFailover
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RebootDbInstanceRequest.ReadOnly =
    zio.aws.rds.model.RebootDbInstanceRequest.wrap(buildAwsValue())
}
object RebootDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RebootDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RebootDbInstanceRequest =
      zio.aws.rds.model.RebootDbInstanceRequest(
        dbInstanceIdentifier,
        forceFailover.map(value => value)
      )
    def dbInstanceIdentifier: String
    def forceFailover: Optional[BooleanOptional]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getForceFailover: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("forceFailover", forceFailover)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RebootDbInstanceRequest
  ) extends zio.aws.rds.model.RebootDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val forceFailover: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forceFailover())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RebootDbInstanceRequest
  ): zio.aws.rds.model.RebootDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
