package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DoubleRange(
    from: Optional[Double] = Optional.Absent,
    to: Optional[Double] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.DoubleRange = {
    import DoubleRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DoubleRange
      .builder()
      .optionallyWith(from.map(value => value: java.lang.Double))(_.from)
      .optionallyWith(to.map(value => value: java.lang.Double))(_.to)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DoubleRange.ReadOnly =
    zio.aws.rds.model.DoubleRange.wrap(buildAwsValue())
}
object DoubleRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DoubleRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DoubleRange = zio.aws.rds.model
      .DoubleRange(from.map(value => value), to.map(value => value))
    def from: Optional[Double]
    def to: Optional[Double]
    def getFrom: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("from", from)
    def getTo: ZIO[Any, AwsError, Double] = AwsError.unwrapOptionField("to", to)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DoubleRange
  ) extends zio.aws.rds.model.DoubleRange.ReadOnly {
    override val from: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.from())
      .map(value => value: Double)
    override val to: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.to())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DoubleRange
  ): zio.aws.rds.model.DoubleRange.ReadOnly = new Wrapper(impl)
}
