package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDbSubnetGroupRequest(dbSubnetGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest = {
    import DeleteDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest
      .builder()
      .dbSubnetGroupName(dbSubnetGroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbSubnetGroupRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbSubnetGroupRequest.wrap(buildAwsValue())
}
object DeleteDbSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbSubnetGroupRequest =
      zio.aws.rds.model.DeleteDbSubnetGroupRequest(dbSubnetGroupName)
    def dbSubnetGroupName: String
    def getDbSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSubnetGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest
  ) extends zio.aws.rds.model.DeleteDbSubnetGroupRequest.ReadOnly {
    override val dbSubnetGroupName: String = impl.dbSubnetGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest
  ): zio.aws.rds.model.DeleteDbSubnetGroupRequest.ReadOnly = new Wrapper(impl)
}
