package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DBClusterSnapshotAttribute(
    attributeName: Optional[String] = Optional.Absent,
    attributeValues: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute = {
    import DBClusterSnapshotAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute
      .builder()
      .optionallyWith(attributeName.map(value => value: java.lang.String))(
        _.attributeName
      )
      .optionallyWith(
        attributeValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.attributeValues)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterSnapshotAttribute.ReadOnly =
    zio.aws.rds.model.DBClusterSnapshotAttribute.wrap(buildAwsValue())
}
object DBClusterSnapshotAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterSnapshotAttribute =
      zio.aws.rds.model.DBClusterSnapshotAttribute(
        attributeName.map(value => value),
        attributeValues.map(value => value)
      )
    def attributeName: Optional[String]
    def attributeValues: Optional[List[String]]
    def getAttributeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("attributeValues", attributeValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute
  ) extends zio.aws.rds.model.DBClusterSnapshotAttribute.ReadOnly {
    override val attributeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value => value: String)
    override val attributeValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute
  ): zio.aws.rds.model.DBClusterSnapshotAttribute.ReadOnly = new Wrapper(impl)
}
