package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopDbInstanceResponse(
    dbInstance: Optional[zio.aws.rds.model.DBInstance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StopDbInstanceResponse = {
    import StopDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StopDbInstanceResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StopDbInstanceResponse.ReadOnly =
    zio.aws.rds.model.StopDbInstanceResponse.wrap(buildAwsValue())
}
object StopDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StopDbInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StopDbInstanceResponse = zio.aws.rds.model
      .StopDbInstanceResponse(dbInstance.map(value => value.asEditable))
    def dbInstance: Optional[zio.aws.rds.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StopDbInstanceResponse
  ) extends zio.aws.rds.model.StopDbInstanceResponse.ReadOnly {
    override val dbInstance: Optional[zio.aws.rds.model.DBInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstance())
        .map(value => zio.aws.rds.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StopDbInstanceResponse
  ): zio.aws.rds.model.StopDbInstanceResponse.ReadOnly = new Wrapper(impl)
}
