package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ScalingConfiguration(
    minCapacity: Optional[IntegerOptional] = Optional.Absent,
    maxCapacity: Optional[IntegerOptional] = Optional.Absent,
    autoPause: Optional[BooleanOptional] = Optional.Absent,
    secondsUntilAutoPause: Optional[IntegerOptional] = Optional.Absent,
    timeoutAction: Optional[String] = Optional.Absent,
    secondsBeforeTimeout: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ScalingConfiguration = {
    import ScalingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ScalingConfiguration
      .builder()
      .optionallyWith(minCapacity.map(value => value: Integer))(_.minCapacity)
      .optionallyWith(maxCapacity.map(value => value: Integer))(_.maxCapacity)
      .optionallyWith(autoPause.map(value => value: java.lang.Boolean))(
        _.autoPause
      )
      .optionallyWith(secondsUntilAutoPause.map(value => value: Integer))(
        _.secondsUntilAutoPause
      )
      .optionallyWith(timeoutAction.map(value => value: java.lang.String))(
        _.timeoutAction
      )
      .optionallyWith(secondsBeforeTimeout.map(value => value: Integer))(
        _.secondsBeforeTimeout
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ScalingConfiguration.ReadOnly =
    zio.aws.rds.model.ScalingConfiguration.wrap(buildAwsValue())
}
object ScalingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ScalingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ScalingConfiguration =
      zio.aws.rds.model.ScalingConfiguration(
        minCapacity.map(value => value),
        maxCapacity.map(value => value),
        autoPause.map(value => value),
        secondsUntilAutoPause.map(value => value),
        timeoutAction.map(value => value),
        secondsBeforeTimeout.map(value => value)
      )
    def minCapacity: Optional[IntegerOptional]
    def maxCapacity: Optional[IntegerOptional]
    def autoPause: Optional[BooleanOptional]
    def secondsUntilAutoPause: Optional[IntegerOptional]
    def timeoutAction: Optional[String]
    def secondsBeforeTimeout: Optional[IntegerOptional]
    def getMinCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("minCapacity", minCapacity)
    def getMaxCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
    def getAutoPause: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("autoPause", autoPause)
    def getSecondsUntilAutoPause: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("secondsUntilAutoPause", secondsUntilAutoPause)
    def getTimeoutAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timeoutAction", timeoutAction)
    def getSecondsBeforeTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("secondsBeforeTimeout", secondsBeforeTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ScalingConfiguration
  ) extends zio.aws.rds.model.ScalingConfiguration.ReadOnly {
    override val minCapacity: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.minCapacity())
      .map(value => value: IntegerOptional)
    override val maxCapacity: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCapacity())
      .map(value => value: IntegerOptional)
    override val autoPause: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.autoPause())
      .map(value => value: BooleanOptional)
    override val secondsUntilAutoPause: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondsUntilAutoPause())
        .map(value => value: IntegerOptional)
    override val timeoutAction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutAction())
      .map(value => value: String)
    override val secondsBeforeTimeout: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondsBeforeTimeout())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ScalingConfiguration
  ): zio.aws.rds.model.ScalingConfiguration.ReadOnly = new Wrapper(impl)
}
