package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  IntegerOptional,
  TStamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RestoreDbClusterToPointInTimeRequest(
    dbClusterIdentifier: String,
    restoreType: Optional[String] = Optional.Absent,
    sourceDBClusterIdentifier: String,
    restoreToTime: Optional[TStamp] = Optional.Absent,
    useLatestRestorableTime: Optional[Boolean] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      Optional.Absent,
    backtrackWindow: Optional[LongOptional] = Optional.Absent,
    enableCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    dbClusterParameterGroupName: Optional[String] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    domainIAMRoleName: Optional[String] = Optional.Absent,
    scalingConfiguration: Optional[zio.aws.rds.model.ScalingConfiguration] =
      Optional.Absent,
    engineMode: Optional[String] = Optional.Absent,
    dbClusterInstanceClass: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    serverlessV2ScalingConfiguration: Optional[
      zio.aws.rds.model.ServerlessV2ScalingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest = {
    import RestoreDbClusterToPointInTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(restoreType.map(value => value: java.lang.String))(
        _.restoreType
      )
      .sourceDBClusterIdentifier(sourceDBClusterIdentifier: java.lang.String)
      .optionallyWith(
        restoreToTime.map(value => TStamp.unwrap(value): Instant)
      )(_.restoreToTime)
      .optionallyWith(
        useLatestRestorableTime.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableTime)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(
        _.backtrackWindow
      )
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(scalingConfiguration.map(value => value.buildAwsValue()))(
        _.scalingConfiguration
      )
      .optionallyWith(engineMode.map(value => value: java.lang.String))(
        _.engineMode
      )
      .optionallyWith(
        dbClusterInstanceClass.map(value => value: java.lang.String)
      )(_.dbClusterInstanceClass)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(
        serverlessV2ScalingConfiguration.map(value => value.buildAwsValue())
      )(_.serverlessV2ScalingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest.ReadOnly =
    zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest.wrap(buildAwsValue())
}
object RestoreDbClusterToPointInTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest =
      zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest(
        dbClusterIdentifier,
        restoreType.map(value => value),
        sourceDBClusterIdentifier,
        restoreToTime.map(value => value),
        useLatestRestorableTime.map(value => value),
        port.map(value => value),
        dbSubnetGroupName.map(value => value),
        optionGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        backtrackWindow.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        dbClusterParameterGroupName.map(value => value),
        deletionProtection.map(value => value),
        copyTagsToSnapshot.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        scalingConfiguration.map(value => value.asEditable),
        engineMode.map(value => value),
        dbClusterInstanceClass.map(value => value),
        storageType.map(value => value),
        publiclyAccessible.map(value => value),
        iops.map(value => value),
        serverlessV2ScalingConfiguration.map(value => value.asEditable)
      )
    def dbClusterIdentifier: String
    def restoreType: Optional[String]
    def sourceDBClusterIdentifier: String
    def restoreToTime: Optional[TStamp]
    def useLatestRestorableTime: Optional[Boolean]
    def port: Optional[IntegerOptional]
    def dbSubnetGroupName: Optional[String]
    def optionGroupName: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def kmsKeyId: Optional[String]
    def enableIAMDatabaseAuthentication: Optional[BooleanOptional]
    def backtrackWindow: Optional[LongOptional]
    def enableCloudwatchLogsExports: Optional[List[String]]
    def dbClusterParameterGroupName: Optional[String]
    def deletionProtection: Optional[BooleanOptional]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def domain: Optional[String]
    def domainIAMRoleName: Optional[String]
    def scalingConfiguration
        : Optional[zio.aws.rds.model.ScalingConfiguration.ReadOnly]
    def engineMode: Optional[String]
    def dbClusterInstanceClass: Optional[String]
    def storageType: Optional[String]
    def publiclyAccessible: Optional[BooleanOptional]
    def iops: Optional[IntegerOptional]
    def serverlessV2ScalingConfiguration
        : Optional[zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getRestoreType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreType", restoreType)
    def getSourceDBClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBClusterIdentifier)
    def getRestoreToTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("restoreToTime", restoreToTime)
    def getUseLatestRestorableTime: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("useLatestRestorableTime", useLatestRestorableTime)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getScalingConfiguration
        : ZIO[Any, AwsError, zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("scalingConfiguration", scalingConfiguration)
    def getEngineMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getDbClusterInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterInstanceClass", dbClusterInstanceClass)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getServerlessV2ScalingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverlessV2ScalingConfiguration",
      serverlessV2ScalingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest
  ) extends zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val restoreType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreType())
      .map(value => value: String)
    override val sourceDBClusterIdentifier: String =
      impl.sourceDBClusterIdentifier(): String
    override val restoreToTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreToTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val useLatestRestorableTime: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useLatestRestorableTime())
        .map(value => value: Boolean)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIAMDatabaseAuthentication())
        .map(value => value: BooleanOptional)
    override val backtrackWindow: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.backtrackWindow())
      .map(value => value: LongOptional)
    override val enableCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val domainIAMRoleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIAMRoleName())
      .map(value => value: String)
    override val scalingConfiguration
        : Optional[zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingConfiguration())
        .map(value => zio.aws.rds.model.ScalingConfiguration.wrap(value))
    override val engineMode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineMode())
      .map(value => value: String)
    override val dbClusterInstanceClass: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterInstanceClass())
        .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val serverlessV2ScalingConfiguration: Optional[
      zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverlessV2ScalingConfiguration())
      .map(value =>
        zio.aws.rds.model.ServerlessV2ScalingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest
  ): zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest.ReadOnly =
    new Wrapper(impl)
}
