package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{Integer, TStamp}
import scala.jdk.CollectionConverters._
final case class ReservedDBInstance(
    reservedDBInstanceId: Optional[String] = Optional.Absent,
    reservedDBInstancesOfferingId: Optional[String] = Optional.Absent,
    dbInstanceClass: Optional[String] = Optional.Absent,
    startTime: Optional[TStamp] = Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    fixedPrice: Optional[Double] = Optional.Absent,
    usagePrice: Optional[Double] = Optional.Absent,
    currencyCode: Optional[String] = Optional.Absent,
    dbInstanceCount: Optional[Integer] = Optional.Absent,
    productDescription: Optional[String] = Optional.Absent,
    offeringType: Optional[String] = Optional.Absent,
    multiAZ: Optional[Boolean] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    recurringCharges: Optional[Iterable[zio.aws.rds.model.RecurringCharge]] =
      Optional.Absent,
    reservedDBInstanceArn: Optional[String] = Optional.Absent,
    leaseId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ReservedDBInstance = {
    import ReservedDBInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ReservedDBInstance
      .builder()
      .optionallyWith(
        reservedDBInstanceId.map(value => value: java.lang.String)
      )(_.reservedDBInstanceId)
      .optionallyWith(
        reservedDBInstancesOfferingId.map(value => value: java.lang.String)
      )(_.reservedDBInstancesOfferingId)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(dbInstanceCount.map(value => value: java.lang.Integer))(
        _.dbInstanceCount
      )
      .optionallyWith(productDescription.map(value => value: java.lang.String))(
        _.productDescription
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(
        reservedDBInstanceArn.map(value => value: java.lang.String)
      )(_.reservedDBInstanceArn)
      .optionallyWith(leaseId.map(value => value: java.lang.String))(_.leaseId)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ReservedDBInstance.ReadOnly =
    zio.aws.rds.model.ReservedDBInstance.wrap(buildAwsValue())
}
object ReservedDBInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ReservedDBInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ReservedDBInstance =
      zio.aws.rds.model.ReservedDBInstance(
        reservedDBInstanceId.map(value => value),
        reservedDBInstancesOfferingId.map(value => value),
        dbInstanceClass.map(value => value),
        startTime.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        dbInstanceCount.map(value => value),
        productDescription.map(value => value),
        offeringType.map(value => value),
        multiAZ.map(value => value),
        state.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedDBInstanceArn.map(value => value),
        leaseId.map(value => value)
      )
    def reservedDBInstanceId: Optional[String]
    def reservedDBInstancesOfferingId: Optional[String]
    def dbInstanceClass: Optional[String]
    def startTime: Optional[TStamp]
    def duration: Optional[Integer]
    def fixedPrice: Optional[Double]
    def usagePrice: Optional[Double]
    def currencyCode: Optional[String]
    def dbInstanceCount: Optional[Integer]
    def productDescription: Optional[String]
    def offeringType: Optional[String]
    def multiAZ: Optional[Boolean]
    def state: Optional[String]
    def recurringCharges
        : Optional[List[zio.aws.rds.model.RecurringCharge.ReadOnly]]
    def reservedDBInstanceArn: Optional[String]
    def leaseId: Optional[String]
    def getReservedDBInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedDBInstanceId", reservedDBInstanceId)
    def getReservedDBInstancesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedDBInstancesOfferingId",
        reservedDBInstancesOfferingId
      )
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getDbInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dbInstanceCount", dbInstanceCount)
    def getProductDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getRecurringCharges
        : ZIO[Any, AwsError, List[zio.aws.rds.model.RecurringCharge.ReadOnly]] =
      AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getReservedDBInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedDBInstanceArn", reservedDBInstanceArn)
    def getLeaseId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("leaseId", leaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ReservedDBInstance
  ) extends zio.aws.rds.model.ReservedDBInstance.ReadOnly {
    override val reservedDBInstanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedDBInstanceId())
      .map(value => value: String)
    override val reservedDBInstancesOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedDBInstancesOfferingId())
        .map(value => value: String)
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val startTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val fixedPrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Double)
    override val usagePrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.usagePrice())
      .map(value => value: Double)
    override val currencyCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currencyCode())
      .map(value => value: String)
    override val dbInstanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceCount())
      .map(value => value: Integer)
    override val productDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.productDescription())
      .map(value => value: String)
    override val offeringType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringType())
      .map(value => value: String)
    override val multiAZ: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: Boolean)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val recurringCharges
        : Optional[List[zio.aws.rds.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.RecurringCharge.wrap(item)
          }.toList
        )
    override val reservedDBInstanceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedDBInstanceArn())
      .map(value => value: String)
    override val leaseId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.leaseId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ReservedDBInstance
  ): zio.aws.rds.model.ReservedDBInstance.ReadOnly = new Wrapper(impl)
}
