package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReservedDbInstancesResponse(
    marker: Optional[String] = Optional.Absent,
    reservedDBInstances: Optional[
      Iterable[zio.aws.rds.model.ReservedDBInstance]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse = {
    import DescribeReservedDbInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        reservedDBInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedDBInstances)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeReservedDbInstancesResponse.ReadOnly =
    zio.aws.rds.model.DescribeReservedDbInstancesResponse.wrap(buildAwsValue())
}
object DescribeReservedDbInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeReservedDbInstancesResponse =
      zio.aws.rds.model.DescribeReservedDbInstancesResponse(
        marker.map(value => value),
        reservedDBInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def reservedDBInstances
        : Optional[List[zio.aws.rds.model.ReservedDBInstance.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReservedDBInstances: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ReservedDBInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("reservedDBInstances", reservedDBInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse
  ) extends zio.aws.rds.model.DescribeReservedDbInstancesResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val reservedDBInstances
        : Optional[List[zio.aws.rds.model.ReservedDBInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedDBInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ReservedDBInstance.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse
  ): zio.aws.rds.model.DescribeReservedDbInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
