package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait TargetState {
  def unwrap: software.amazon.awssdk.services.rds.model.TargetState
}
object TargetState {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.TargetState
  ): zio.aws.rds.model.TargetState = value match {
    case software.amazon.awssdk.services.rds.model.TargetState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.TargetState.REGISTERING =>
      val r = REGISTERING
      r
    case software.amazon.awssdk.services.rds.model.TargetState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.rds.model.TargetState.UNAVAILABLE =>
      val r = UNAVAILABLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.TargetState {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetState =
      software.amazon.awssdk.services.rds.model.TargetState.UNKNOWN_TO_SDK_VERSION
  }
  case object REGISTERING extends zio.aws.rds.model.TargetState {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetState =
      software.amazon.awssdk.services.rds.model.TargetState.REGISTERING
  }
  case object AVAILABLE extends zio.aws.rds.model.TargetState {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetState =
      software.amazon.awssdk.services.rds.model.TargetState.AVAILABLE
  }
  case object UNAVAILABLE extends zio.aws.rds.model.TargetState {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetState =
      software.amazon.awssdk.services.rds.model.TargetState.UNAVAILABLE
  }
}
