package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbInstancesResponse(
    marker: Optional[String] = Optional.Absent,
    dbInstances: Optional[Iterable[zio.aws.rds.model.DBInstance]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse = {
    import DescribeDbInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbInstances)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbInstancesResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbInstancesResponse.wrap(buildAwsValue())
}
object DescribeDbInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbInstancesResponse =
      zio.aws.rds.model.DescribeDbInstancesResponse(
        marker.map(value => value),
        dbInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbInstances: Optional[List[zio.aws.rds.model.DBInstance.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbInstances
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBInstance.ReadOnly]] =
      AwsError.unwrapOptionField("dbInstances", dbInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse
  ) extends zio.aws.rds.model.DescribeDbInstancesResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbInstances
        : Optional[List[zio.aws.rds.model.DBInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBInstance.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse
  ): zio.aws.rds.model.DescribeDbInstancesResponse.ReadOnly = new Wrapper(impl)
}
