package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait CustomEngineVersionStatus {
  def unwrap
      : software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus
}
object CustomEngineVersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus
  ): zio.aws.rds.model.CustomEngineVersionStatus = value match {
    case software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus.INACTIVE =>
      val r = inactive
      r
    case software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus.INACTIVE_EXCEPT_RESTORE =>
      val r = `inactive-except-restore`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rds.model.CustomEngineVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus =
      software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object available extends zio.aws.rds.model.CustomEngineVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus =
      software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus.AVAILABLE
  }
  case object inactive extends zio.aws.rds.model.CustomEngineVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus =
      software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus.INACTIVE
  }
  case object `inactive-except-restore`
      extends zio.aws.rds.model.CustomEngineVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus =
      software.amazon.awssdk.services.rds.model.CustomEngineVersionStatus.INACTIVE_EXCEPT_RESTORE
  }
}
