package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait ApplyMethod {
  def unwrap: software.amazon.awssdk.services.rds.model.ApplyMethod
}
object ApplyMethod {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.ApplyMethod
  ): zio.aws.rds.model.ApplyMethod = value match {
    case software.amazon.awssdk.services.rds.model.ApplyMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.ApplyMethod.IMMEDIATE =>
      val r = immediate
      r
    case software.amazon.awssdk.services.rds.model.ApplyMethod.PENDING_REBOOT =>
      val r = `pending-reboot`
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.ApplyMethod {
    override def unwrap: software.amazon.awssdk.services.rds.model.ApplyMethod =
      software.amazon.awssdk.services.rds.model.ApplyMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object immediate extends zio.aws.rds.model.ApplyMethod {
    override def unwrap: software.amazon.awssdk.services.rds.model.ApplyMethod =
      software.amazon.awssdk.services.rds.model.ApplyMethod.IMMEDIATE
  }
  case object `pending-reboot` extends zio.aws.rds.model.ApplyMethod {
    override def unwrap: software.amazon.awssdk.services.rds.model.ApplyMethod =
      software.amazon.awssdk.services.rds.model.ApplyMethod.PENDING_REBOOT
  }
}
