package zio.aws.rds
import zio.aws.rds.model.RestoreDbInstanceFromS3Response.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.rds.RdsAsyncClient
import zio.aws.core.AwsError
import zio.aws.rds.model.{
  DescribeEventCategoriesRequest,
  ResetDbParameterGroupRequest,
  DescribeOptionGroupOptionsRequest,
  DescribeDbClusterSnapshotsRequest,
  DescribeExportTasksRequest,
  AuthorizeDbSecurityGroupIngressRequest,
  PromoteReadReplicaDbClusterRequest,
  DescribeDbSnapshotAttributesRequest,
  RegisterDbProxyTargetsRequest,
  StartExportTaskRequest,
  ModifyEventSubscriptionRequest,
  CreateCustomDbEngineVersionRequest,
  ModifyCertificatesRequest,
  DescribeOptionGroupsRequest,
  PromoteReadReplicaRequest,
  AddRoleToDbClusterRequest,
  ModifyDbProxyTargetGroupRequest,
  DeleteDbSubnetGroupRequest,
  DescribeDbClusterEndpointsRequest,
  DescribeDbProxyTargetGroupsRequest,
  ModifyDbClusterSnapshotAttributeRequest,
  StartActivityStreamRequest,
  DeleteDbProxyRequest,
  CreateOptionGroupRequest,
  DescribeEngineDefaultParametersRequest,
  ModifyGlobalClusterRequest,
  DescribeDbLogFilesRequest,
  CreateEventSubscriptionRequest,
  AddTagsToResourceRequest,
  CreateDbClusterEndpointRequest,
  DeleteDbClusterRequest,
  StartDbInstanceAutomatedBackupsReplicationRequest,
  DescribeValidDbInstanceModificationsRequest,
  RestoreDbClusterFromSnapshotRequest,
  DeleteGlobalClusterRequest,
  DescribeDbClusterBacktracksRequest,
  CopyDbClusterSnapshotRequest,
  CopyDbSnapshotRequest,
  DeleteDbClusterSnapshotRequest,
  ModifyDbParameterGroupRequest,
  DescribeDbProxyTargetsRequest,
  DescribeEventsRequest,
  FailoverGlobalClusterRequest,
  CreateDbParameterGroupRequest,
  StartDbInstanceRequest,
  StopDbInstanceAutomatedBackupsReplicationRequest,
  DeleteCustomDbEngineVersionRequest,
  DescribeDbInstancesRequest,
  ApplyPendingMaintenanceActionRequest,
  DescribeDbEngineVersionsRequest,
  ListTagsForResourceRequest,
  DeleteEventSubscriptionRequest,
  ModifyDbClusterParameterGroupRequest,
  DescribeDbSecurityGroupsRequest,
  DescribeDbClusterSnapshotAttributesRequest,
  DescribeReservedDbInstancesOfferingsRequest,
  StartDbClusterRequest,
  RestoreDbInstanceFromS3Request,
  DescribeDbClustersRequest,
  DeleteOptionGroupRequest,
  CreateGlobalClusterRequest,
  CreateDbSubnetGroupRequest,
  FailoverDbClusterRequest,
  ModifyDbProxyRequest,
  CreateDbClusterRequest,
  RebootDbClusterRequest,
  CreateDbInstanceReadReplicaRequest,
  CreateDbProxyRequest,
  ModifyDbClusterRequest,
  CreateDbSecurityGroupRequest,
  DeleteDbSnapshotRequest,
  CopyDbParameterGroupRequest,
  RemoveFromGlobalClusterRequest,
  DeleteDbSecurityGroupRequest,
  ModifyDbInstanceRequest,
  DescribeDbClusterParametersRequest,
  RemoveTagsFromResourceRequest,
  DescribeSourceRegionsRequest,
  RemoveRoleFromDbInstanceRequest,
  StopDbInstanceRequest,
  PurchaseReservedDbInstancesOfferingRequest,
  ModifyDbClusterEndpointRequest,
  DescribeCertificatesRequest,
  DescribePendingMaintenanceActionsRequest,
  ModifyDbSubnetGroupRequest,
  DescribeDbInstanceAutomatedBackupsRequest,
  RestoreDbInstanceFromDbSnapshotRequest,
  DescribeDbClusterParameterGroupsRequest,
  ModifyDbSnapshotRequest,
  DeleteDbClusterEndpointRequest,
  CopyDbClusterParameterGroupRequest,
  DescribeDbProxiesRequest,
  StopDbClusterRequest,
  DeleteDbClusterParameterGroupRequest,
  CopyOptionGroupRequest,
  RestoreDbInstanceToPointInTimeRequest,
  RemoveSourceIdentifierFromSubscriptionRequest,
  RestoreDbClusterToPointInTimeRequest,
  DeleteDbProxyEndpointRequest,
  DeleteDbInstanceRequest,
  DescribeAccountAttributesRequest,
  DescribeDbProxyEndpointsRequest,
  CreateDbInstanceRequest,
  DescribeDbSubnetGroupsRequest,
  DescribeEngineDefaultClusterParametersRequest,
  CancelExportTaskRequest,
  ResetDbClusterParameterGroupRequest,
  DescribeReservedDbInstancesRequest,
  ModifyCurrentDbClusterCapacityRequest,
  BacktrackDbClusterRequest,
  ModifyCustomDbEngineVersionRequest,
  RestoreDbClusterFromS3Request,
  RebootDbInstanceRequest,
  ModifyDbSnapshotAttributeRequest,
  DescribeOrderableDbInstanceOptionsRequest,
  CreateDbSnapshotRequest,
  ModifyDbProxyEndpointRequest,
  AddRoleToDbInstanceRequest,
  DescribeGlobalClustersRequest,
  DescribeDbParameterGroupsRequest,
  DescribeEventSubscriptionsRequest,
  ModifyOptionGroupRequest,
  RevokeDbSecurityGroupIngressRequest,
  DeleteDbParameterGroupRequest,
  DownloadDbLogFilePortionRequest,
  AddSourceIdentifierToSubscriptionRequest,
  DescribeDbSnapshotsRequest,
  DeleteDbInstanceAutomatedBackupRequest,
  StopActivityStreamRequest,
  DeregisterDbProxyTargetsRequest,
  RemoveRoleFromDbClusterRequest,
  CreateDbClusterParameterGroupRequest,
  CreateDbClusterSnapshotRequest,
  DescribeDbParametersRequest,
  CreateDbProxyEndpointRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object RdsMock extends Mock[Rds] {
  object DownloadDBLogFilePortion
      extends Effect[
        DownloadDbLogFilePortionRequest,
        AwsError,
        zio.aws.rds.model.DownloadDbLogFilePortionResponse.ReadOnly
      ]
  object CopyDBClusterSnapshot
      extends Effect[
        CopyDbClusterSnapshotRequest,
        AwsError,
        zio.aws.rds.model.CopyDbClusterSnapshotResponse.ReadOnly
      ]
  object DescribeEngineDefaultParameters
      extends Effect[
        DescribeEngineDefaultParametersRequest,
        AwsError,
        zio.aws.rds.model.DescribeEngineDefaultParametersResponse.ReadOnly
      ]
  object ModifyDBInstance
      extends Effect[
        ModifyDbInstanceRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbInstanceResponse.ReadOnly
      ]
  object DeleteDBProxy
      extends Effect[
        DeleteDbProxyRequest,
        AwsError,
        zio.aws.rds.model.DeleteDbProxyResponse.ReadOnly
      ]
  object DescribeDBClusterEndpoints
      extends Stream[
        DescribeDbClusterEndpointsRequest,
        AwsError,
        zio.aws.rds.model.DBClusterEndpoint.ReadOnly
      ]
  object DescribeDBClusterEndpointsPaginated
      extends Effect[
        DescribeDbClusterEndpointsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbClusterEndpointsResponse.ReadOnly
      ]
  object StopActivityStream
      extends Effect[
        StopActivityStreamRequest,
        AwsError,
        zio.aws.rds.model.StopActivityStreamResponse.ReadOnly
      ]
  object FailoverGlobalCluster
      extends Effect[
        FailoverGlobalClusterRequest,
        AwsError,
        zio.aws.rds.model.FailoverGlobalClusterResponse.ReadOnly
      ]
  object DescribeDBLogFiles
      extends Stream[
        DescribeDbLogFilesRequest,
        AwsError,
        zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly
      ]
  object DescribeDBLogFilesPaginated
      extends Effect[
        DescribeDbLogFilesRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbLogFilesResponse.ReadOnly
      ]
  object DescribeDBSnapshots
      extends Stream[
        DescribeDbSnapshotsRequest,
        AwsError,
        zio.aws.rds.model.DBSnapshot.ReadOnly
      ]
  object DescribeDBSnapshotsPaginated
      extends Effect[
        DescribeDbSnapshotsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbSnapshotsResponse.ReadOnly
      ]
  object DescribeDBParameters
      extends Stream[
        DescribeDbParametersRequest,
        AwsError,
        zio.aws.rds.model.Parameter.ReadOnly
      ]
  object DescribeDBParametersPaginated
      extends Effect[
        DescribeDbParametersRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbParametersResponse.ReadOnly
      ]
  object AddTagsToResource
      extends Effect[AddTagsToResourceRequest, AwsError, Unit]
  object DescribeDBProxies
      extends Stream[
        DescribeDbProxiesRequest,
        AwsError,
        zio.aws.rds.model.DBProxy.ReadOnly
      ]
  object DescribeDBProxiesPaginated
      extends Effect[
        DescribeDbProxiesRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbProxiesResponse.ReadOnly
      ]
  object DescribeDBClusterSnapshots
      extends Stream[
        DescribeDbClusterSnapshotsRequest,
        AwsError,
        zio.aws.rds.model.DBClusterSnapshot.ReadOnly
      ]
  object DescribeDBClusterSnapshotsPaginated
      extends Effect[
        DescribeDbClusterSnapshotsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbClusterSnapshotsResponse.ReadOnly
      ]
  object ResetDBClusterParameterGroup
      extends Effect[
        ResetDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.rds.model.ResetDbClusterParameterGroupResponse.ReadOnly
      ]
  object DescribeDBProxyEndpoints
      extends Stream[
        DescribeDbProxyEndpointsRequest,
        AwsError,
        zio.aws.rds.model.DBProxyEndpoint.ReadOnly
      ]
  object DescribeDBProxyEndpointsPaginated
      extends Effect[
        DescribeDbProxyEndpointsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbProxyEndpointsResponse.ReadOnly
      ]
  object RemoveSourceIdentifierFromSubscription
      extends Effect[
        RemoveSourceIdentifierFromSubscriptionRequest,
        AwsError,
        zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
      ]
  object DescribeEngineDefaultClusterParameters
      extends Effect[
        DescribeEngineDefaultClusterParametersRequest,
        AwsError,
        zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
      ]
  object CreateDBSubnetGroup
      extends Effect[
        CreateDbSubnetGroupRequest,
        AwsError,
        zio.aws.rds.model.CreateDbSubnetGroupResponse.ReadOnly
      ]
  object CreateDBClusterEndpoint
      extends Effect[
        CreateDbClusterEndpointRequest,
        AwsError,
        zio.aws.rds.model.CreateDbClusterEndpointResponse.ReadOnly
      ]
  object AddRoleToDBCluster
      extends Effect[AddRoleToDbClusterRequest, AwsError, Unit]
  object ModifyCustomDBEngineVersion
      extends Effect[
        ModifyCustomDbEngineVersionRequest,
        AwsError,
        zio.aws.rds.model.ModifyCustomDbEngineVersionResponse.ReadOnly
      ]
  object CopyDBClusterParameterGroup
      extends Effect[
        CopyDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.rds.model.CopyDbClusterParameterGroupResponse.ReadOnly
      ]
  object DescribePendingMaintenanceActions
      extends Stream[
        DescribePendingMaintenanceActionsRequest,
        AwsError,
        zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly
      ]
  object DescribePendingMaintenanceActionsPaginated
      extends Effect[
        DescribePendingMaintenanceActionsRequest,
        AwsError,
        zio.aws.rds.model.DescribePendingMaintenanceActionsResponse.ReadOnly
      ]
  object DeleteDBClusterEndpoint
      extends Effect[
        DeleteDbClusterEndpointRequest,
        AwsError,
        zio.aws.rds.model.DeleteDbClusterEndpointResponse.ReadOnly
      ]
  object AddRoleToDBInstance
      extends Effect[AddRoleToDbInstanceRequest, AwsError, Unit]
  object StartActivityStream
      extends Effect[
        StartActivityStreamRequest,
        AwsError,
        zio.aws.rds.model.StartActivityStreamResponse.ReadOnly
      ]
  object DeleteDBClusterParameterGroup
      extends Effect[DeleteDbClusterParameterGroupRequest, AwsError, Unit]
  object CreateDBSecurityGroup
      extends Effect[
        CreateDbSecurityGroupRequest,
        AwsError,
        zio.aws.rds.model.CreateDbSecurityGroupResponse.ReadOnly
      ]
  object DescribeSourceRegions
      extends Stream[
        DescribeSourceRegionsRequest,
        AwsError,
        zio.aws.rds.model.SourceRegion.ReadOnly
      ]
  object DescribeSourceRegionsPaginated
      extends Effect[
        DescribeSourceRegionsRequest,
        AwsError,
        zio.aws.rds.model.DescribeSourceRegionsResponse.ReadOnly
      ]
  object BacktrackDBCluster
      extends Effect[
        BacktrackDbClusterRequest,
        AwsError,
        zio.aws.rds.model.BacktrackDbClusterResponse.ReadOnly
      ]
  object RemoveFromGlobalCluster
      extends Effect[
        RemoveFromGlobalClusterRequest,
        AwsError,
        zio.aws.rds.model.RemoveFromGlobalClusterResponse.ReadOnly
      ]
  object ModifyDBClusterParameterGroup
      extends Effect[
        ModifyDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbClusterParameterGroupResponse.ReadOnly
      ]
  object RebootDBCluster
      extends Effect[
        RebootDbClusterRequest,
        AwsError,
        zio.aws.rds.model.RebootDbClusterResponse.ReadOnly
      ]
  object CancelExportTask
      extends Effect[
        CancelExportTaskRequest,
        AwsError,
        zio.aws.rds.model.CancelExportTaskResponse.ReadOnly
      ]
  object CreateDBSnapshot
      extends Effect[
        CreateDbSnapshotRequest,
        AwsError,
        zio.aws.rds.model.CreateDbSnapshotResponse.ReadOnly
      ]
  object DeleteDBInstanceAutomatedBackup
      extends Effect[
        DeleteDbInstanceAutomatedBackupRequest,
        AwsError,
        zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse.ReadOnly
      ]
  object DeleteDBSnapshot
      extends Effect[
        DeleteDbSnapshotRequest,
        AwsError,
        zio.aws.rds.model.DeleteDbSnapshotResponse.ReadOnly
      ]
  object StopDBCluster
      extends Effect[
        StopDbClusterRequest,
        AwsError,
        zio.aws.rds.model.StopDbClusterResponse.ReadOnly
      ]
  object CreateDBCluster
      extends Effect[
        CreateDbClusterRequest,
        AwsError,
        zio.aws.rds.model.CreateDbClusterResponse.ReadOnly
      ]
  object DescribeCertificates
      extends Stream[
        DescribeCertificatesRequest,
        AwsError,
        zio.aws.rds.model.Certificate.ReadOnly
      ]
  object DescribeCertificatesPaginated
      extends Effect[
        DescribeCertificatesRequest,
        AwsError,
        zio.aws.rds.model.DescribeCertificatesResponse.ReadOnly
      ]
  object ModifyDBSnapshot
      extends Effect[
        ModifyDbSnapshotRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbSnapshotResponse.ReadOnly
      ]
  object DeleteEventSubscription
      extends Effect[
        DeleteEventSubscriptionRequest,
        AwsError,
        zio.aws.rds.model.DeleteEventSubscriptionResponse.ReadOnly
      ]
  object DeleteDBSecurityGroup
      extends Effect[DeleteDbSecurityGroupRequest, AwsError, Unit]
  object DeleteDBParameterGroup
      extends Effect[DeleteDbParameterGroupRequest, AwsError, Unit]
  object DescribeDBSecurityGroups
      extends Stream[
        DescribeDbSecurityGroupsRequest,
        AwsError,
        zio.aws.rds.model.DBSecurityGroup.ReadOnly
      ]
  object DescribeDBSecurityGroupsPaginated
      extends Effect[
        DescribeDbSecurityGroupsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbSecurityGroupsResponse.ReadOnly
      ]
  object PurchaseReservedDBInstancesOffering
      extends Effect[
        PurchaseReservedDbInstancesOfferingRequest,
        AwsError,
        zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse.ReadOnly
      ]
  object DescribeDBSubnetGroups
      extends Stream[
        DescribeDbSubnetGroupsRequest,
        AwsError,
        zio.aws.rds.model.DBSubnetGroup.ReadOnly
      ]
  object DescribeDBSubnetGroupsPaginated
      extends Effect[
        DescribeDbSubnetGroupsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbSubnetGroupsResponse.ReadOnly
      ]
  object RemoveRoleFromDBCluster
      extends Effect[RemoveRoleFromDbClusterRequest, AwsError, Unit]
  object CreateDBClusterParameterGroup
      extends Effect[
        CreateDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.rds.model.CreateDbClusterParameterGroupResponse.ReadOnly
      ]
  object ModifyDBCluster
      extends Effect[
        ModifyDbClusterRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbClusterResponse.ReadOnly
      ]
  object RestoreDBClusterFromS3
      extends Effect[
        RestoreDbClusterFromS3Request,
        AwsError,
        zio.aws.rds.model.RestoreDbClusterFromS3Response.ReadOnly
      ]
  object DescribeValidDBInstanceModifications
      extends Effect[
        DescribeValidDbInstanceModificationsRequest,
        AwsError,
        zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse.ReadOnly
      ]
  object CreateDBProxyEndpoint
      extends Effect[
        CreateDbProxyEndpointRequest,
        AwsError,
        zio.aws.rds.model.CreateDbProxyEndpointResponse.ReadOnly
      ]
  object ResetDBParameterGroup
      extends Effect[
        ResetDbParameterGroupRequest,
        AwsError,
        zio.aws.rds.model.ResetDbParameterGroupResponse.ReadOnly
      ]
  object DeleteDBProxyEndpoint
      extends Effect[
        DeleteDbProxyEndpointRequest,
        AwsError,
        zio.aws.rds.model.DeleteDbProxyEndpointResponse.ReadOnly
      ]
  object RemoveTagsFromResource
      extends Effect[RemoveTagsFromResourceRequest, AwsError, Unit]
  object PromoteReadReplica
      extends Effect[
        PromoteReadReplicaRequest,
        AwsError,
        zio.aws.rds.model.PromoteReadReplicaResponse.ReadOnly
      ]
  object DescribeReservedDBInstancesOfferings
      extends Stream[
        DescribeReservedDbInstancesOfferingsRequest,
        AwsError,
        zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly
      ]
  object DescribeReservedDBInstancesOfferingsPaginated
      extends Effect[
        DescribeReservedDbInstancesOfferingsRequest,
        AwsError,
        zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.ReadOnly
      ]
  object CreateDBParameterGroup
      extends Effect[
        CreateDbParameterGroupRequest,
        AwsError,
        zio.aws.rds.model.CreateDbParameterGroupResponse.ReadOnly
      ]
  object StartExportTask
      extends Effect[
        StartExportTaskRequest,
        AwsError,
        zio.aws.rds.model.StartExportTaskResponse.ReadOnly
      ]
  object ApplyPendingMaintenanceAction
      extends Effect[
        ApplyPendingMaintenanceActionRequest,
        AwsError,
        zio.aws.rds.model.ApplyPendingMaintenanceActionResponse.ReadOnly
      ]
  object ModifyDBSubnetGroup
      extends Effect[
        ModifyDbSubnetGroupRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbSubnetGroupResponse.ReadOnly
      ]
  object ModifyGlobalCluster
      extends Effect[
        ModifyGlobalClusterRequest,
        AwsError,
        zio.aws.rds.model.ModifyGlobalClusterResponse.ReadOnly
      ]
  object CopyDBSnapshot
      extends Effect[
        CopyDbSnapshotRequest,
        AwsError,
        zio.aws.rds.model.CopyDbSnapshotResponse.ReadOnly
      ]
  object RestoreDBClusterFromSnapshot
      extends Effect[
        RestoreDbClusterFromSnapshotRequest,
        AwsError,
        zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
      ]
  object CopyOptionGroup
      extends Effect[
        CopyOptionGroupRequest,
        AwsError,
        zio.aws.rds.model.CopyOptionGroupResponse.ReadOnly
      ]
  object RestoreDBInstanceFromS3
      extends Effect[RestoreDbInstanceFromS3Request, AwsError, ReadOnly]
  object RemoveRoleFromDBInstance
      extends Effect[RemoveRoleFromDbInstanceRequest, AwsError, Unit]
  object DescribeGlobalClusters
      extends Stream[
        DescribeGlobalClustersRequest,
        AwsError,
        zio.aws.rds.model.GlobalCluster.ReadOnly
      ]
  object DescribeGlobalClustersPaginated
      extends Effect[
        DescribeGlobalClustersRequest,
        AwsError,
        zio.aws.rds.model.DescribeGlobalClustersResponse.ReadOnly
      ]
  object DescribeDBProxyTargetGroups
      extends Stream[
        DescribeDbProxyTargetGroupsRequest,
        AwsError,
        zio.aws.rds.model.DBProxyTargetGroup.ReadOnly
      ]
  object DescribeDBProxyTargetGroupsPaginated
      extends Effect[
        DescribeDbProxyTargetGroupsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse.ReadOnly
      ]
  object DescribeDBInstanceAutomatedBackups
      extends Stream[
        DescribeDbInstanceAutomatedBackupsRequest,
        AwsError,
        zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly
      ]
  object DescribeDBInstanceAutomatedBackupsPaginated
      extends Effect[
        DescribeDbInstanceAutomatedBackupsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse.ReadOnly
      ]
  object DescribeDBClusterParameters
      extends Stream[
        DescribeDbClusterParametersRequest,
        AwsError,
        zio.aws.rds.model.Parameter.ReadOnly
      ]
  object DescribeDBClusterParametersPaginated
      extends Effect[
        DescribeDbClusterParametersRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbClusterParametersResponse.ReadOnly
      ]
  object CopyDBParameterGroup
      extends Effect[
        CopyDbParameterGroupRequest,
        AwsError,
        zio.aws.rds.model.CopyDbParameterGroupResponse.ReadOnly
      ]
  object ModifyDBSnapshotAttribute
      extends Effect[
        ModifyDbSnapshotAttributeRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbSnapshotAttributeResponse.ReadOnly
      ]
  object AuthorizeDBSecurityGroupIngress
      extends Effect[
        AuthorizeDbSecurityGroupIngressRequest,
        AwsError,
        zio.aws.rds.model.AuthorizeDbSecurityGroupIngressResponse.ReadOnly
      ]
  object ModifyEventSubscription
      extends Effect[
        ModifyEventSubscriptionRequest,
        AwsError,
        zio.aws.rds.model.ModifyEventSubscriptionResponse.ReadOnly
      ]
  object DescribeDBClusterBacktracks
      extends Stream[
        DescribeDbClusterBacktracksRequest,
        AwsError,
        zio.aws.rds.model.DBClusterBacktrack.ReadOnly
      ]
  object DescribeDBClusterBacktracksPaginated
      extends Effect[
        DescribeDbClusterBacktracksRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbClusterBacktracksResponse.ReadOnly
      ]
  object ModifyDBParameterGroup
      extends Effect[
        ModifyDbParameterGroupRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbParameterGroupResponse.ReadOnly
      ]
  object ModifyCertificates
      extends Effect[
        ModifyCertificatesRequest,
        AwsError,
        zio.aws.rds.model.ModifyCertificatesResponse.ReadOnly
      ]
  object CreateDBInstance
      extends Effect[
        CreateDbInstanceRequest,
        AwsError,
        zio.aws.rds.model.CreateDbInstanceResponse.ReadOnly
      ]
  object DeleteDBClusterSnapshot
      extends Effect[
        DeleteDbClusterSnapshotRequest,
        AwsError,
        zio.aws.rds.model.DeleteDbClusterSnapshotResponse.ReadOnly
      ]
  object DescribeExportTasks
      extends Stream[
        DescribeExportTasksRequest,
        AwsError,
        zio.aws.rds.model.ExportTask.ReadOnly
      ]
  object DescribeExportTasksPaginated
      extends Effect[
        DescribeExportTasksRequest,
        AwsError,
        zio.aws.rds.model.DescribeExportTasksResponse.ReadOnly
      ]
  object StartDBCluster
      extends Effect[
        StartDbClusterRequest,
        AwsError,
        zio.aws.rds.model.StartDbClusterResponse.ReadOnly
      ]
  object ModifyDBClusterSnapshotAttribute
      extends Effect[
        ModifyDbClusterSnapshotAttributeRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
      ]
  object CreateDBProxy
      extends Effect[
        CreateDbProxyRequest,
        AwsError,
        zio.aws.rds.model.CreateDbProxyResponse.ReadOnly
      ]
  object DescribeDBSnapshotAttributes
      extends Effect[
        DescribeDbSnapshotAttributesRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbSnapshotAttributesResponse.ReadOnly
      ]
  object DescribeEventCategories
      extends Effect[
        DescribeEventCategoriesRequest,
        AwsError,
        zio.aws.rds.model.DescribeEventCategoriesResponse.ReadOnly
      ]
  object DeleteDBSubnetGroup
      extends Effect[DeleteDbSubnetGroupRequest, AwsError, Unit]
  object ModifyDBClusterEndpoint
      extends Effect[
        ModifyDbClusterEndpointRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbClusterEndpointResponse.ReadOnly
      ]
  object StartDBInstance
      extends Effect[
        StartDbInstanceRequest,
        AwsError,
        zio.aws.rds.model.StartDbInstanceResponse.ReadOnly
      ]
  object PromoteReadReplicaDBCluster
      extends Effect[
        PromoteReadReplicaDbClusterRequest,
        AwsError,
        zio.aws.rds.model.PromoteReadReplicaDbClusterResponse.ReadOnly
      ]
  object RegisterDBProxyTargets
      extends Effect[
        RegisterDbProxyTargetsRequest,
        AwsError,
        zio.aws.rds.model.RegisterDbProxyTargetsResponse.ReadOnly
      ]
  object StopDBInstance
      extends Effect[
        StopDbInstanceRequest,
        AwsError,
        zio.aws.rds.model.StopDbInstanceResponse.ReadOnly
      ]
  object ModifyDBProxyTargetGroup
      extends Effect[
        ModifyDbProxyTargetGroupRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbProxyTargetGroupResponse.ReadOnly
      ]
  object RestoreDBInstanceFromDBSnapshot
      extends Effect[
        RestoreDbInstanceFromDbSnapshotRequest,
        AwsError,
        zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse.ReadOnly
      ]
  object RebootDBInstance
      extends Effect[
        RebootDbInstanceRequest,
        AwsError,
        zio.aws.rds.model.RebootDbInstanceResponse.ReadOnly
      ]
  object DescribeOptionGroupOptions
      extends Stream[
        DescribeOptionGroupOptionsRequest,
        AwsError,
        zio.aws.rds.model.OptionGroupOption.ReadOnly
      ]
  object DescribeOptionGroupOptionsPaginated
      extends Effect[
        DescribeOptionGroupOptionsRequest,
        AwsError,
        zio.aws.rds.model.DescribeOptionGroupOptionsResponse.ReadOnly
      ]
  object StartDBInstanceAutomatedBackupsReplication
      extends Effect[
        StartDbInstanceAutomatedBackupsReplicationRequest,
        AwsError,
        zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse.ReadOnly
      ]
  object DescribeDBClusterParameterGroups
      extends Stream[
        DescribeDbClusterParameterGroupsRequest,
        AwsError,
        zio.aws.rds.model.DBClusterParameterGroup.ReadOnly
      ]
  object DescribeDBClusterParameterGroupsPaginated
      extends Effect[
        DescribeDbClusterParameterGroupsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
      ]
  object RestoreDBInstanceToPointInTime
      extends Effect[
        RestoreDbInstanceToPointInTimeRequest,
        AwsError,
        zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse.ReadOnly
      ]
  object CreateEventSubscription
      extends Effect[
        CreateEventSubscriptionRequest,
        AwsError,
        zio.aws.rds.model.CreateEventSubscriptionResponse.ReadOnly
      ]
  object CreateCustomDBEngineVersion
      extends Effect[
        CreateCustomDbEngineVersionRequest,
        AwsError,
        zio.aws.rds.model.CreateCustomDbEngineVersionResponse.ReadOnly
      ]
  object DescribeOptionGroups
      extends Stream[
        DescribeOptionGroupsRequest,
        AwsError,
        zio.aws.rds.model.OptionGroup.ReadOnly
      ]
  object DescribeOptionGroupsPaginated
      extends Effect[
        DescribeOptionGroupsRequest,
        AwsError,
        zio.aws.rds.model.DescribeOptionGroupsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.rds.model.ListTagsForResourceResponse.ReadOnly
      ]
  object RestoreDBClusterToPointInTime
      extends Effect[
        RestoreDbClusterToPointInTimeRequest,
        AwsError,
        zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
      ]
  object DescribeDBProxyTargets
      extends Stream[
        DescribeDbProxyTargetsRequest,
        AwsError,
        zio.aws.rds.model.DBProxyTarget.ReadOnly
      ]
  object DescribeDBProxyTargetsPaginated
      extends Effect[
        DescribeDbProxyTargetsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbProxyTargetsResponse.ReadOnly
      ]
  object DescribeDBClusters
      extends Stream[
        DescribeDbClustersRequest,
        AwsError,
        zio.aws.rds.model.DBCluster.ReadOnly
      ]
  object DescribeDBClustersPaginated
      extends Effect[
        DescribeDbClustersRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbClustersResponse.ReadOnly
      ]
  object FailoverDBCluster
      extends Effect[
        FailoverDbClusterRequest,
        AwsError,
        zio.aws.rds.model.FailoverDbClusterResponse.ReadOnly
      ]
  object DeleteOptionGroup
      extends Effect[DeleteOptionGroupRequest, AwsError, Unit]
  object DescribeEventSubscriptions
      extends Stream[
        DescribeEventSubscriptionsRequest,
        AwsError,
        zio.aws.rds.model.EventSubscription.ReadOnly
      ]
  object DescribeEventSubscriptionsPaginated
      extends Effect[
        DescribeEventSubscriptionsRequest,
        AwsError,
        zio.aws.rds.model.DescribeEventSubscriptionsResponse.ReadOnly
      ]
  object DescribeDBInstances
      extends Stream[
        DescribeDbInstancesRequest,
        AwsError,
        zio.aws.rds.model.DBInstance.ReadOnly
      ]
  object DescribeDBInstancesPaginated
      extends Effect[
        DescribeDbInstancesRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbInstancesResponse.ReadOnly
      ]
  object CreateDBClusterSnapshot
      extends Effect[
        CreateDbClusterSnapshotRequest,
        AwsError,
        zio.aws.rds.model.CreateDbClusterSnapshotResponse.ReadOnly
      ]
  object ModifyCurrentDBClusterCapacity
      extends Effect[
        ModifyCurrentDbClusterCapacityRequest,
        AwsError,
        zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.ReadOnly
      ]
  object DeleteDBCluster
      extends Effect[
        DeleteDbClusterRequest,
        AwsError,
        zio.aws.rds.model.DeleteDbClusterResponse.ReadOnly
      ]
  object DeleteGlobalCluster
      extends Effect[
        DeleteGlobalClusterRequest,
        AwsError,
        zio.aws.rds.model.DeleteGlobalClusterResponse.ReadOnly
      ]
  object DescribeReservedDBInstances
      extends Stream[
        DescribeReservedDbInstancesRequest,
        AwsError,
        zio.aws.rds.model.ReservedDBInstance.ReadOnly
      ]
  object DescribeReservedDBInstancesPaginated
      extends Effect[
        DescribeReservedDbInstancesRequest,
        AwsError,
        zio.aws.rds.model.DescribeReservedDbInstancesResponse.ReadOnly
      ]
  object CreateDBInstanceReadReplica
      extends Effect[
        CreateDbInstanceReadReplicaRequest,
        AwsError,
        zio.aws.rds.model.CreateDbInstanceReadReplicaResponse.ReadOnly
      ]
  object DeleteDBInstance
      extends Effect[
        DeleteDbInstanceRequest,
        AwsError,
        zio.aws.rds.model.DeleteDbInstanceResponse.ReadOnly
      ]
  object CreateOptionGroup
      extends Effect[
        CreateOptionGroupRequest,
        AwsError,
        zio.aws.rds.model.CreateOptionGroupResponse.ReadOnly
      ]
  object DeregisterDBProxyTargets
      extends Effect[
        DeregisterDbProxyTargetsRequest,
        AwsError,
        zio.aws.rds.model.DeregisterDbProxyTargetsResponse.ReadOnly
      ]
  object ModifyDBProxyEndpoint
      extends Effect[
        ModifyDbProxyEndpointRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbProxyEndpointResponse.ReadOnly
      ]
  object AddSourceIdentifierToSubscription
      extends Effect[
        AddSourceIdentifierToSubscriptionRequest,
        AwsError,
        zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
      ]
  object ModifyDBProxy
      extends Effect[
        ModifyDbProxyRequest,
        AwsError,
        zio.aws.rds.model.ModifyDbProxyResponse.ReadOnly
      ]
  object ModifyOptionGroup
      extends Effect[
        ModifyOptionGroupRequest,
        AwsError,
        zio.aws.rds.model.ModifyOptionGroupResponse.ReadOnly
      ]
  object DescribeDBEngineVersions
      extends Stream[
        DescribeDbEngineVersionsRequest,
        AwsError,
        zio.aws.rds.model.DBEngineVersion.ReadOnly
      ]
  object DescribeDBEngineVersionsPaginated
      extends Effect[
        DescribeDbEngineVersionsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbEngineVersionsResponse.ReadOnly
      ]
  object DescribeAccountAttributes
      extends Effect[
        DescribeAccountAttributesRequest,
        AwsError,
        zio.aws.rds.model.DescribeAccountAttributesResponse.ReadOnly
      ]
  object CreateGlobalCluster
      extends Effect[
        CreateGlobalClusterRequest,
        AwsError,
        zio.aws.rds.model.CreateGlobalClusterResponse.ReadOnly
      ]
  object DescribeOrderableDBInstanceOptions
      extends Stream[
        DescribeOrderableDbInstanceOptionsRequest,
        AwsError,
        zio.aws.rds.model.OrderableDBInstanceOption.ReadOnly
      ]
  object DescribeOrderableDBInstanceOptionsPaginated
      extends Effect[
        DescribeOrderableDbInstanceOptionsRequest,
        AwsError,
        zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
      ]
  object RevokeDBSecurityGroupIngress
      extends Effect[
        RevokeDbSecurityGroupIngressRequest,
        AwsError,
        zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse.ReadOnly
      ]
  object DescribeDBClusterSnapshotAttributes
      extends Effect[
        DescribeDbClusterSnapshotAttributesRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
      ]
  object StopDBInstanceAutomatedBackupsReplication
      extends Effect[
        StopDbInstanceAutomatedBackupsReplicationRequest,
        AwsError,
        zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse.ReadOnly
      ]
  object DescribeEvents
      extends Stream[
        DescribeEventsRequest,
        AwsError,
        zio.aws.rds.model.Event.ReadOnly
      ]
  object DescribeEventsPaginated
      extends Effect[
        DescribeEventsRequest,
        AwsError,
        zio.aws.rds.model.DescribeEventsResponse.ReadOnly
      ]
  object DeleteCustomDBEngineVersion
      extends Effect[
        DeleteCustomDbEngineVersionRequest,
        AwsError,
        zio.aws.rds.model.DeleteCustomDbEngineVersionResponse.ReadOnly
      ]
  object DescribeDBParameterGroups
      extends Stream[
        DescribeDbParameterGroupsRequest,
        AwsError,
        zio.aws.rds.model.DBParameterGroup.ReadOnly
      ]
  object DescribeDBParameterGroupsPaginated
      extends Effect[
        DescribeDbParameterGroupsRequest,
        AwsError,
        zio.aws.rds.model.DescribeDbParameterGroupsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Rds] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Rds {
          val api: RdsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Rds = this
          def downloadDBLogFilePortion(
              request: DownloadDbLogFilePortionRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DownloadDbLogFilePortionResponse.ReadOnly
          ] = proxy(DownloadDBLogFilePortion, request)
          def copyDBClusterSnapshot(request: CopyDbClusterSnapshotRequest): IO[
            AwsError,
            zio.aws.rds.model.CopyDbClusterSnapshotResponse.ReadOnly
          ] = proxy(CopyDBClusterSnapshot, request)
          def describeEngineDefaultParameters(
              request: DescribeEngineDefaultParametersRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeEngineDefaultParametersResponse.ReadOnly
          ] = proxy(DescribeEngineDefaultParameters, request)
          def modifyDBInstance(
              request: ModifyDbInstanceRequest
          ): IO[AwsError, zio.aws.rds.model.ModifyDbInstanceResponse.ReadOnly] =
            proxy(ModifyDBInstance, request)
          def deleteDBProxy(
              request: DeleteDbProxyRequest
          ): IO[AwsError, zio.aws.rds.model.DeleteDbProxyResponse.ReadOnly] =
            proxy(DeleteDBProxy, request)
          def describeDBClusterEndpoints(
              request: DescribeDbClusterEndpointsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.DBClusterEndpoint.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDBClusterEndpoints, request))
          def describeDBClusterEndpointsPaginated(
              request: DescribeDbClusterEndpointsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbClusterEndpointsResponse.ReadOnly
          ] = proxy(DescribeDBClusterEndpointsPaginated, request)
          def stopActivityStream(request: StopActivityStreamRequest): IO[
            AwsError,
            zio.aws.rds.model.StopActivityStreamResponse.ReadOnly
          ] = proxy(StopActivityStream, request)
          def failoverGlobalCluster(request: FailoverGlobalClusterRequest): IO[
            AwsError,
            zio.aws.rds.model.FailoverGlobalClusterResponse.ReadOnly
          ] = proxy(FailoverGlobalCluster, request)
          def describeDBLogFiles(request: DescribeDbLogFilesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDBLogFiles, request))
          def describeDBLogFilesPaginated(
              request: DescribeDbLogFilesRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbLogFilesResponse.ReadOnly
          ] = proxy(DescribeDBLogFilesPaginated, request)
          def describeDBSnapshots(
              request: DescribeDbSnapshotsRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.DBSnapshot.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDBSnapshots, request))
          def describeDBSnapshotsPaginated(
              request: DescribeDbSnapshotsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbSnapshotsResponse.ReadOnly
          ] = proxy(DescribeDBSnapshotsPaginated, request)
          def describeDBParameters(
              request: DescribeDbParametersRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.Parameter.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDBParameters, request))
          def describeDBParametersPaginated(
              request: DescribeDbParametersRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbParametersResponse.ReadOnly
          ] = proxy(DescribeDBParametersPaginated, request)
          def addTagsToResource(
              request: AddTagsToResourceRequest
          ): IO[AwsError, Unit] = proxy(AddTagsToResource, request)
          def describeDBProxies(
              request: DescribeDbProxiesRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.DBProxy.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDBProxies, request))
          def describeDBProxiesPaginated(request: DescribeDbProxiesRequest): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbProxiesResponse.ReadOnly
          ] = proxy(DescribeDBProxiesPaginated, request)
          def describeDBClusterSnapshots(
              request: DescribeDbClusterSnapshotsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.DBClusterSnapshot.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDBClusterSnapshots, request))
          def describeDBClusterSnapshotsPaginated(
              request: DescribeDbClusterSnapshotsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbClusterSnapshotsResponse.ReadOnly
          ] = proxy(DescribeDBClusterSnapshotsPaginated, request)
          def resetDBClusterParameterGroup(
              request: ResetDbClusterParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.ResetDbClusterParameterGroupResponse.ReadOnly
          ] = proxy(ResetDBClusterParameterGroup, request)
          def describeDBProxyEndpoints(
              request: DescribeDbProxyEndpointsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.DBProxyEndpoint.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDBProxyEndpoints, request))
          def describeDBProxyEndpointsPaginated(
              request: DescribeDbProxyEndpointsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbProxyEndpointsResponse.ReadOnly
          ] = proxy(DescribeDBProxyEndpointsPaginated, request)
          def removeSourceIdentifierFromSubscription(
              request: RemoveSourceIdentifierFromSubscriptionRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
          ] = proxy(RemoveSourceIdentifierFromSubscription, request)
          def describeEngineDefaultClusterParameters(
              request: DescribeEngineDefaultClusterParametersRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
          ] = proxy(DescribeEngineDefaultClusterParameters, request)
          def createDBSubnetGroup(request: CreateDbSubnetGroupRequest): IO[
            AwsError,
            zio.aws.rds.model.CreateDbSubnetGroupResponse.ReadOnly
          ] = proxy(CreateDBSubnetGroup, request)
          def createDBClusterEndpoint(
              request: CreateDbClusterEndpointRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.CreateDbClusterEndpointResponse.ReadOnly
          ] = proxy(CreateDBClusterEndpoint, request)
          def addRoleToDBCluster(
              request: AddRoleToDbClusterRequest
          ): IO[AwsError, Unit] = proxy(AddRoleToDBCluster, request)
          def modifyCustomDBEngineVersion(
              request: ModifyCustomDbEngineVersionRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.ModifyCustomDbEngineVersionResponse.ReadOnly
          ] = proxy(ModifyCustomDBEngineVersion, request)
          def copyDBClusterParameterGroup(
              request: CopyDbClusterParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.CopyDbClusterParameterGroupResponse.ReadOnly
          ] = proxy(CopyDBClusterParameterGroup, request)
          def describePendingMaintenanceActions(
              request: DescribePendingMaintenanceActionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly
          ] = rts.unsafeRun(proxy(DescribePendingMaintenanceActions, request))
          def describePendingMaintenanceActionsPaginated(
              request: DescribePendingMaintenanceActionsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribePendingMaintenanceActionsResponse.ReadOnly
          ] = proxy(DescribePendingMaintenanceActionsPaginated, request)
          def deleteDBClusterEndpoint(
              request: DeleteDbClusterEndpointRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DeleteDbClusterEndpointResponse.ReadOnly
          ] = proxy(DeleteDBClusterEndpoint, request)
          def addRoleToDBInstance(
              request: AddRoleToDbInstanceRequest
          ): IO[AwsError, Unit] = proxy(AddRoleToDBInstance, request)
          def startActivityStream(request: StartActivityStreamRequest): IO[
            AwsError,
            zio.aws.rds.model.StartActivityStreamResponse.ReadOnly
          ] = proxy(StartActivityStream, request)
          def deleteDBClusterParameterGroup(
              request: DeleteDbClusterParameterGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteDBClusterParameterGroup, request)
          def createDBSecurityGroup(request: CreateDbSecurityGroupRequest): IO[
            AwsError,
            zio.aws.rds.model.CreateDbSecurityGroupResponse.ReadOnly
          ] = proxy(CreateDBSecurityGroup, request)
          def describeSourceRegions(
              request: DescribeSourceRegionsRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.SourceRegion.ReadOnly] =
            rts.unsafeRun(proxy(DescribeSourceRegions, request))
          def describeSourceRegionsPaginated(
              request: DescribeSourceRegionsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeSourceRegionsResponse.ReadOnly
          ] = proxy(DescribeSourceRegionsPaginated, request)
          def backtrackDBCluster(request: BacktrackDbClusterRequest): IO[
            AwsError,
            zio.aws.rds.model.BacktrackDbClusterResponse.ReadOnly
          ] = proxy(BacktrackDBCluster, request)
          def removeFromGlobalCluster(
              request: RemoveFromGlobalClusterRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.RemoveFromGlobalClusterResponse.ReadOnly
          ] = proxy(RemoveFromGlobalCluster, request)
          def modifyDBClusterParameterGroup(
              request: ModifyDbClusterParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.ModifyDbClusterParameterGroupResponse.ReadOnly
          ] = proxy(ModifyDBClusterParameterGroup, request)
          def rebootDBCluster(
              request: RebootDbClusterRequest
          ): IO[AwsError, zio.aws.rds.model.RebootDbClusterResponse.ReadOnly] =
            proxy(RebootDBCluster, request)
          def cancelExportTask(
              request: CancelExportTaskRequest
          ): IO[AwsError, zio.aws.rds.model.CancelExportTaskResponse.ReadOnly] =
            proxy(CancelExportTask, request)
          def createDBSnapshot(
              request: CreateDbSnapshotRequest
          ): IO[AwsError, zio.aws.rds.model.CreateDbSnapshotResponse.ReadOnly] =
            proxy(CreateDBSnapshot, request)
          def deleteDBInstanceAutomatedBackup(
              request: DeleteDbInstanceAutomatedBackupRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse.ReadOnly
          ] = proxy(DeleteDBInstanceAutomatedBackup, request)
          def deleteDBSnapshot(
              request: DeleteDbSnapshotRequest
          ): IO[AwsError, zio.aws.rds.model.DeleteDbSnapshotResponse.ReadOnly] =
            proxy(DeleteDBSnapshot, request)
          def stopDBCluster(
              request: StopDbClusterRequest
          ): IO[AwsError, zio.aws.rds.model.StopDbClusterResponse.ReadOnly] =
            proxy(StopDBCluster, request)
          def createDBCluster(
              request: CreateDbClusterRequest
          ): IO[AwsError, zio.aws.rds.model.CreateDbClusterResponse.ReadOnly] =
            proxy(CreateDBCluster, request)
          def describeCertificates(
              request: DescribeCertificatesRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.Certificate.ReadOnly] =
            rts.unsafeRun(proxy(DescribeCertificates, request))
          def describeCertificatesPaginated(
              request: DescribeCertificatesRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeCertificatesResponse.ReadOnly
          ] = proxy(DescribeCertificatesPaginated, request)
          def modifyDBSnapshot(
              request: ModifyDbSnapshotRequest
          ): IO[AwsError, zio.aws.rds.model.ModifyDbSnapshotResponse.ReadOnly] =
            proxy(ModifyDBSnapshot, request)
          def deleteEventSubscription(
              request: DeleteEventSubscriptionRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DeleteEventSubscriptionResponse.ReadOnly
          ] = proxy(DeleteEventSubscription, request)
          def deleteDBSecurityGroup(
              request: DeleteDbSecurityGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteDBSecurityGroup, request)
          def deleteDBParameterGroup(
              request: DeleteDbParameterGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteDBParameterGroup, request)
          def describeDBSecurityGroups(
              request: DescribeDbSecurityGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.DBSecurityGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDBSecurityGroups, request))
          def describeDBSecurityGroupsPaginated(
              request: DescribeDbSecurityGroupsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbSecurityGroupsResponse.ReadOnly
          ] = proxy(DescribeDBSecurityGroupsPaginated, request)
          def purchaseReservedDBInstancesOffering(
              request: PurchaseReservedDbInstancesOfferingRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse.ReadOnly
          ] = proxy(PurchaseReservedDBInstancesOffering, request)
          def describeDBSubnetGroups(
              request: DescribeDbSubnetGroupsRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.DBSubnetGroup.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDBSubnetGroups, request))
          def describeDBSubnetGroupsPaginated(
              request: DescribeDbSubnetGroupsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbSubnetGroupsResponse.ReadOnly
          ] = proxy(DescribeDBSubnetGroupsPaginated, request)
          def removeRoleFromDBCluster(
              request: RemoveRoleFromDbClusterRequest
          ): IO[AwsError, Unit] = proxy(RemoveRoleFromDBCluster, request)
          def createDBClusterParameterGroup(
              request: CreateDbClusterParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.CreateDbClusterParameterGroupResponse.ReadOnly
          ] = proxy(CreateDBClusterParameterGroup, request)
          def modifyDBCluster(
              request: ModifyDbClusterRequest
          ): IO[AwsError, zio.aws.rds.model.ModifyDbClusterResponse.ReadOnly] =
            proxy(ModifyDBCluster, request)
          def restoreDBClusterFromS3(
              request: RestoreDbClusterFromS3Request
          ): IO[
            AwsError,
            zio.aws.rds.model.RestoreDbClusterFromS3Response.ReadOnly
          ] = proxy(RestoreDBClusterFromS3, request)
          def describeValidDBInstanceModifications(
              request: DescribeValidDbInstanceModificationsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse.ReadOnly
          ] = proxy(DescribeValidDBInstanceModifications, request)
          def createDBProxyEndpoint(request: CreateDbProxyEndpointRequest): IO[
            AwsError,
            zio.aws.rds.model.CreateDbProxyEndpointResponse.ReadOnly
          ] = proxy(CreateDBProxyEndpoint, request)
          def resetDBParameterGroup(request: ResetDbParameterGroupRequest): IO[
            AwsError,
            zio.aws.rds.model.ResetDbParameterGroupResponse.ReadOnly
          ] = proxy(ResetDBParameterGroup, request)
          def deleteDBProxyEndpoint(request: DeleteDbProxyEndpointRequest): IO[
            AwsError,
            zio.aws.rds.model.DeleteDbProxyEndpointResponse.ReadOnly
          ] = proxy(DeleteDBProxyEndpoint, request)
          def removeTagsFromResource(
              request: RemoveTagsFromResourceRequest
          ): IO[AwsError, Unit] = proxy(RemoveTagsFromResource, request)
          def promoteReadReplica(request: PromoteReadReplicaRequest): IO[
            AwsError,
            zio.aws.rds.model.PromoteReadReplicaResponse.ReadOnly
          ] = proxy(PromoteReadReplica, request)
          def describeReservedDBInstancesOfferings(
              request: DescribeReservedDbInstancesOfferingsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly
          ] =
            rts.unsafeRun(proxy(DescribeReservedDBInstancesOfferings, request))
          def describeReservedDBInstancesOfferingsPaginated(
              request: DescribeReservedDbInstancesOfferingsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.ReadOnly
          ] = proxy(DescribeReservedDBInstancesOfferingsPaginated, request)
          def createDBParameterGroup(
              request: CreateDbParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.CreateDbParameterGroupResponse.ReadOnly
          ] = proxy(CreateDBParameterGroup, request)
          def startExportTask(
              request: StartExportTaskRequest
          ): IO[AwsError, zio.aws.rds.model.StartExportTaskResponse.ReadOnly] =
            proxy(StartExportTask, request)
          def applyPendingMaintenanceAction(
              request: ApplyPendingMaintenanceActionRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.ApplyPendingMaintenanceActionResponse.ReadOnly
          ] = proxy(ApplyPendingMaintenanceAction, request)
          def modifyDBSubnetGroup(request: ModifyDbSubnetGroupRequest): IO[
            AwsError,
            zio.aws.rds.model.ModifyDbSubnetGroupResponse.ReadOnly
          ] = proxy(ModifyDBSubnetGroup, request)
          def modifyGlobalCluster(request: ModifyGlobalClusterRequest): IO[
            AwsError,
            zio.aws.rds.model.ModifyGlobalClusterResponse.ReadOnly
          ] = proxy(ModifyGlobalCluster, request)
          def copyDBSnapshot(
              request: CopyDbSnapshotRequest
          ): IO[AwsError, zio.aws.rds.model.CopyDbSnapshotResponse.ReadOnly] =
            proxy(CopyDBSnapshot, request)
          def restoreDBClusterFromSnapshot(
              request: RestoreDbClusterFromSnapshotRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
          ] = proxy(RestoreDBClusterFromSnapshot, request)
          def copyOptionGroup(
              request: CopyOptionGroupRequest
          ): IO[AwsError, zio.aws.rds.model.CopyOptionGroupResponse.ReadOnly] =
            proxy(CopyOptionGroup, request)
          def restoreDBInstanceFromS3(
              request: RestoreDbInstanceFromS3Request
          ): IO[AwsError, ReadOnly] = proxy(RestoreDBInstanceFromS3, request)
          def removeRoleFromDBInstance(
              request: RemoveRoleFromDbInstanceRequest
          ): IO[AwsError, Unit] = proxy(RemoveRoleFromDBInstance, request)
          def describeGlobalClusters(
              request: DescribeGlobalClustersRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.GlobalCluster.ReadOnly] =
            rts.unsafeRun(proxy(DescribeGlobalClusters, request))
          def describeGlobalClustersPaginated(
              request: DescribeGlobalClustersRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeGlobalClustersResponse.ReadOnly
          ] = proxy(DescribeGlobalClustersPaginated, request)
          def describeDBProxyTargetGroups(
              request: DescribeDbProxyTargetGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.DBProxyTargetGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDBProxyTargetGroups, request))
          def describeDBProxyTargetGroupsPaginated(
              request: DescribeDbProxyTargetGroupsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse.ReadOnly
          ] = proxy(DescribeDBProxyTargetGroupsPaginated, request)
          def describeDBInstanceAutomatedBackups(
              request: DescribeDbInstanceAutomatedBackupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDBInstanceAutomatedBackups, request))
          def describeDBInstanceAutomatedBackupsPaginated(
              request: DescribeDbInstanceAutomatedBackupsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse.ReadOnly
          ] = proxy(DescribeDBInstanceAutomatedBackupsPaginated, request)
          def describeDBClusterParameters(
              request: DescribeDbClusterParametersRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.Parameter.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDBClusterParameters, request))
          def describeDBClusterParametersPaginated(
              request: DescribeDbClusterParametersRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbClusterParametersResponse.ReadOnly
          ] = proxy(DescribeDBClusterParametersPaginated, request)
          def copyDBParameterGroup(request: CopyDbParameterGroupRequest): IO[
            AwsError,
            zio.aws.rds.model.CopyDbParameterGroupResponse.ReadOnly
          ] = proxy(CopyDBParameterGroup, request)
          def modifyDBSnapshotAttribute(
              request: ModifyDbSnapshotAttributeRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.ModifyDbSnapshotAttributeResponse.ReadOnly
          ] = proxy(ModifyDBSnapshotAttribute, request)
          def authorizeDBSecurityGroupIngress(
              request: AuthorizeDbSecurityGroupIngressRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.AuthorizeDbSecurityGroupIngressResponse.ReadOnly
          ] = proxy(AuthorizeDBSecurityGroupIngress, request)
          def modifyEventSubscription(
              request: ModifyEventSubscriptionRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.ModifyEventSubscriptionResponse.ReadOnly
          ] = proxy(ModifyEventSubscription, request)
          def describeDBClusterBacktracks(
              request: DescribeDbClusterBacktracksRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.DBClusterBacktrack.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDBClusterBacktracks, request))
          def describeDBClusterBacktracksPaginated(
              request: DescribeDbClusterBacktracksRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbClusterBacktracksResponse.ReadOnly
          ] = proxy(DescribeDBClusterBacktracksPaginated, request)
          def modifyDBParameterGroup(
              request: ModifyDbParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.ModifyDbParameterGroupResponse.ReadOnly
          ] = proxy(ModifyDBParameterGroup, request)
          def modifyCertificates(request: ModifyCertificatesRequest): IO[
            AwsError,
            zio.aws.rds.model.ModifyCertificatesResponse.ReadOnly
          ] = proxy(ModifyCertificates, request)
          def createDBInstance(
              request: CreateDbInstanceRequest
          ): IO[AwsError, zio.aws.rds.model.CreateDbInstanceResponse.ReadOnly] =
            proxy(CreateDBInstance, request)
          def deleteDBClusterSnapshot(
              request: DeleteDbClusterSnapshotRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DeleteDbClusterSnapshotResponse.ReadOnly
          ] = proxy(DeleteDBClusterSnapshot, request)
          def describeExportTasks(
              request: DescribeExportTasksRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.ExportTask.ReadOnly] =
            rts.unsafeRun(proxy(DescribeExportTasks, request))
          def describeExportTasksPaginated(
              request: DescribeExportTasksRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeExportTasksResponse.ReadOnly
          ] = proxy(DescribeExportTasksPaginated, request)
          def startDBCluster(
              request: StartDbClusterRequest
          ): IO[AwsError, zio.aws.rds.model.StartDbClusterResponse.ReadOnly] =
            proxy(StartDBCluster, request)
          def modifyDBClusterSnapshotAttribute(
              request: ModifyDbClusterSnapshotAttributeRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
          ] = proxy(ModifyDBClusterSnapshotAttribute, request)
          def createDBProxy(
              request: CreateDbProxyRequest
          ): IO[AwsError, zio.aws.rds.model.CreateDbProxyResponse.ReadOnly] =
            proxy(CreateDBProxy, request)
          def describeDBSnapshotAttributes(
              request: DescribeDbSnapshotAttributesRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbSnapshotAttributesResponse.ReadOnly
          ] = proxy(DescribeDBSnapshotAttributes, request)
          def describeEventCategories(
              request: DescribeEventCategoriesRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeEventCategoriesResponse.ReadOnly
          ] = proxy(DescribeEventCategories, request)
          def deleteDBSubnetGroup(
              request: DeleteDbSubnetGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteDBSubnetGroup, request)
          def modifyDBClusterEndpoint(
              request: ModifyDbClusterEndpointRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.ModifyDbClusterEndpointResponse.ReadOnly
          ] = proxy(ModifyDBClusterEndpoint, request)
          def startDBInstance(
              request: StartDbInstanceRequest
          ): IO[AwsError, zio.aws.rds.model.StartDbInstanceResponse.ReadOnly] =
            proxy(StartDBInstance, request)
          def promoteReadReplicaDBCluster(
              request: PromoteReadReplicaDbClusterRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.PromoteReadReplicaDbClusterResponse.ReadOnly
          ] = proxy(PromoteReadReplicaDBCluster, request)
          def registerDBProxyTargets(
              request: RegisterDbProxyTargetsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.RegisterDbProxyTargetsResponse.ReadOnly
          ] = proxy(RegisterDBProxyTargets, request)
          def stopDBInstance(
              request: StopDbInstanceRequest
          ): IO[AwsError, zio.aws.rds.model.StopDbInstanceResponse.ReadOnly] =
            proxy(StopDBInstance, request)
          def modifyDBProxyTargetGroup(
              request: ModifyDbProxyTargetGroupRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.ModifyDbProxyTargetGroupResponse.ReadOnly
          ] = proxy(ModifyDBProxyTargetGroup, request)
          def restoreDBInstanceFromDBSnapshot(
              request: RestoreDbInstanceFromDbSnapshotRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse.ReadOnly
          ] = proxy(RestoreDBInstanceFromDBSnapshot, request)
          def rebootDBInstance(
              request: RebootDbInstanceRequest
          ): IO[AwsError, zio.aws.rds.model.RebootDbInstanceResponse.ReadOnly] =
            proxy(RebootDBInstance, request)
          def describeOptionGroupOptions(
              request: DescribeOptionGroupOptionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.OptionGroupOption.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeOptionGroupOptions, request))
          def describeOptionGroupOptionsPaginated(
              request: DescribeOptionGroupOptionsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeOptionGroupOptionsResponse.ReadOnly
          ] = proxy(DescribeOptionGroupOptionsPaginated, request)
          def startDBInstanceAutomatedBackupsReplication(
              request: StartDbInstanceAutomatedBackupsReplicationRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse.ReadOnly
          ] = proxy(StartDBInstanceAutomatedBackupsReplication, request)
          def describeDBClusterParameterGroups(
              request: DescribeDbClusterParameterGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.DBClusterParameterGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDBClusterParameterGroups, request))
          def describeDBClusterParameterGroupsPaginated(
              request: DescribeDbClusterParameterGroupsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
          ] = proxy(DescribeDBClusterParameterGroupsPaginated, request)
          def restoreDBInstanceToPointInTime(
              request: RestoreDbInstanceToPointInTimeRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse.ReadOnly
          ] = proxy(RestoreDBInstanceToPointInTime, request)
          def createEventSubscription(
              request: CreateEventSubscriptionRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.CreateEventSubscriptionResponse.ReadOnly
          ] = proxy(CreateEventSubscription, request)
          def createCustomDBEngineVersion(
              request: CreateCustomDbEngineVersionRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.CreateCustomDbEngineVersionResponse.ReadOnly
          ] = proxy(CreateCustomDBEngineVersion, request)
          def describeOptionGroups(
              request: DescribeOptionGroupsRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.OptionGroup.ReadOnly] =
            rts.unsafeRun(proxy(DescribeOptionGroups, request))
          def describeOptionGroupsPaginated(
              request: DescribeOptionGroupsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeOptionGroupsResponse.ReadOnly
          ] = proxy(DescribeOptionGroupsPaginated, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.rds.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def restoreDBClusterToPointInTime(
              request: RestoreDbClusterToPointInTimeRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
          ] = proxy(RestoreDBClusterToPointInTime, request)
          def describeDBProxyTargets(
              request: DescribeDbProxyTargetsRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.DBProxyTarget.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDBProxyTargets, request))
          def describeDBProxyTargetsPaginated(
              request: DescribeDbProxyTargetsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbProxyTargetsResponse.ReadOnly
          ] = proxy(DescribeDBProxyTargetsPaginated, request)
          def describeDBClusters(
              request: DescribeDbClustersRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.DBCluster.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDBClusters, request))
          def describeDBClustersPaginated(
              request: DescribeDbClustersRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbClustersResponse.ReadOnly
          ] = proxy(DescribeDBClustersPaginated, request)
          def failoverDBCluster(request: FailoverDbClusterRequest): IO[
            AwsError,
            zio.aws.rds.model.FailoverDbClusterResponse.ReadOnly
          ] = proxy(FailoverDBCluster, request)
          def deleteOptionGroup(
              request: DeleteOptionGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteOptionGroup, request)
          def describeEventSubscriptions(
              request: DescribeEventSubscriptionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.EventSubscription.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeEventSubscriptions, request))
          def describeEventSubscriptionsPaginated(
              request: DescribeEventSubscriptionsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeEventSubscriptionsResponse.ReadOnly
          ] = proxy(DescribeEventSubscriptionsPaginated, request)
          def describeDBInstances(
              request: DescribeDbInstancesRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDBInstances, request))
          def describeDBInstancesPaginated(
              request: DescribeDbInstancesRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbInstancesResponse.ReadOnly
          ] = proxy(DescribeDBInstancesPaginated, request)
          def createDBClusterSnapshot(
              request: CreateDbClusterSnapshotRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.CreateDbClusterSnapshotResponse.ReadOnly
          ] = proxy(CreateDBClusterSnapshot, request)
          def modifyCurrentDBClusterCapacity(
              request: ModifyCurrentDbClusterCapacityRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.ReadOnly
          ] = proxy(ModifyCurrentDBClusterCapacity, request)
          def deleteDBCluster(
              request: DeleteDbClusterRequest
          ): IO[AwsError, zio.aws.rds.model.DeleteDbClusterResponse.ReadOnly] =
            proxy(DeleteDBCluster, request)
          def deleteGlobalCluster(request: DeleteGlobalClusterRequest): IO[
            AwsError,
            zio.aws.rds.model.DeleteGlobalClusterResponse.ReadOnly
          ] = proxy(DeleteGlobalCluster, request)
          def describeReservedDBInstances(
              request: DescribeReservedDbInstancesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.ReservedDBInstance.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeReservedDBInstances, request))
          def describeReservedDBInstancesPaginated(
              request: DescribeReservedDbInstancesRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeReservedDbInstancesResponse.ReadOnly
          ] = proxy(DescribeReservedDBInstancesPaginated, request)
          def createDBInstanceReadReplica(
              request: CreateDbInstanceReadReplicaRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.CreateDbInstanceReadReplicaResponse.ReadOnly
          ] = proxy(CreateDBInstanceReadReplica, request)
          def deleteDBInstance(
              request: DeleteDbInstanceRequest
          ): IO[AwsError, zio.aws.rds.model.DeleteDbInstanceResponse.ReadOnly] =
            proxy(DeleteDBInstance, request)
          def createOptionGroup(request: CreateOptionGroupRequest): IO[
            AwsError,
            zio.aws.rds.model.CreateOptionGroupResponse.ReadOnly
          ] = proxy(CreateOptionGroup, request)
          def deregisterDBProxyTargets(
              request: DeregisterDbProxyTargetsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DeregisterDbProxyTargetsResponse.ReadOnly
          ] = proxy(DeregisterDBProxyTargets, request)
          def modifyDBProxyEndpoint(request: ModifyDbProxyEndpointRequest): IO[
            AwsError,
            zio.aws.rds.model.ModifyDbProxyEndpointResponse.ReadOnly
          ] = proxy(ModifyDBProxyEndpoint, request)
          def addSourceIdentifierToSubscription(
              request: AddSourceIdentifierToSubscriptionRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
          ] = proxy(AddSourceIdentifierToSubscription, request)
          def modifyDBProxy(
              request: ModifyDbProxyRequest
          ): IO[AwsError, zio.aws.rds.model.ModifyDbProxyResponse.ReadOnly] =
            proxy(ModifyDBProxy, request)
          def modifyOptionGroup(request: ModifyOptionGroupRequest): IO[
            AwsError,
            zio.aws.rds.model.ModifyOptionGroupResponse.ReadOnly
          ] = proxy(ModifyOptionGroup, request)
          def describeDBEngineVersions(
              request: DescribeDbEngineVersionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.DBEngineVersion.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDBEngineVersions, request))
          def describeDBEngineVersionsPaginated(
              request: DescribeDbEngineVersionsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbEngineVersionsResponse.ReadOnly
          ] = proxy(DescribeDBEngineVersionsPaginated, request)
          def describeAccountAttributes(
              request: DescribeAccountAttributesRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeAccountAttributesResponse.ReadOnly
          ] = proxy(DescribeAccountAttributes, request)
          def createGlobalCluster(request: CreateGlobalClusterRequest): IO[
            AwsError,
            zio.aws.rds.model.CreateGlobalClusterResponse.ReadOnly
          ] = proxy(CreateGlobalCluster, request)
          def describeOrderableDBInstanceOptions(
              request: DescribeOrderableDbInstanceOptionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.OrderableDBInstanceOption.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeOrderableDBInstanceOptions, request))
          def describeOrderableDBInstanceOptionsPaginated(
              request: DescribeOrderableDbInstanceOptionsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
          ] = proxy(DescribeOrderableDBInstanceOptionsPaginated, request)
          def revokeDBSecurityGroupIngress(
              request: RevokeDbSecurityGroupIngressRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse.ReadOnly
          ] = proxy(RevokeDBSecurityGroupIngress, request)
          def describeDBClusterSnapshotAttributes(
              request: DescribeDbClusterSnapshotAttributesRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
          ] = proxy(DescribeDBClusterSnapshotAttributes, request)
          def stopDBInstanceAutomatedBackupsReplication(
              request: StopDbInstanceAutomatedBackupsReplicationRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse.ReadOnly
          ] = proxy(StopDBInstanceAutomatedBackupsReplication, request)
          def describeEvents(
              request: DescribeEventsRequest
          ): ZStream[Any, AwsError, zio.aws.rds.model.Event.ReadOnly] =
            rts.unsafeRun(proxy(DescribeEvents, request))
          def describeEventsPaginated(
              request: DescribeEventsRequest
          ): IO[AwsError, zio.aws.rds.model.DescribeEventsResponse.ReadOnly] =
            proxy(DescribeEventsPaginated, request)
          def deleteCustomDBEngineVersion(
              request: DeleteCustomDbEngineVersionRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DeleteCustomDbEngineVersionResponse.ReadOnly
          ] = proxy(DeleteCustomDBEngineVersion, request)
          def describeDBParameterGroups(
              request: DescribeDbParameterGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.rds.model.DBParameterGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeDBParameterGroups, request))
          def describeDBParameterGroupsPaginated(
              request: DescribeDbParameterGroupsRequest
          ): IO[
            AwsError,
            zio.aws.rds.model.DescribeDbParameterGroupsResponse.ReadOnly
          ] = proxy(DescribeDBParameterGroupsPaginated, request)
        }
      }
    }
  }
}
