package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartExportTaskRequest(
    exportTaskIdentifier: String,
    sourceArn: String,
    s3BucketName: String,
    iamRoleArn: String,
    kmsKeyId: String,
    s3Prefix: Optional[String] = Optional.Absent,
    exportOnly: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StartExportTaskRequest = {
    import StartExportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StartExportTaskRequest
      .builder()
      .exportTaskIdentifier(exportTaskIdentifier: java.lang.String)
      .sourceArn(sourceArn: java.lang.String)
      .s3BucketName(s3BucketName: java.lang.String)
      .iamRoleArn(iamRoleArn: java.lang.String)
      .kmsKeyId(kmsKeyId: java.lang.String)
      .optionallyWith(s3Prefix.map(value => value: java.lang.String))(
        _.s3Prefix
      )
      .optionallyWith(
        exportOnly.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exportOnly)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StartExportTaskRequest.ReadOnly =
    zio.aws.rds.model.StartExportTaskRequest.wrap(buildAwsValue())
}
object StartExportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StartExportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StartExportTaskRequest =
      zio.aws.rds.model.StartExportTaskRequest(
        exportTaskIdentifier,
        sourceArn,
        s3BucketName,
        iamRoleArn,
        kmsKeyId,
        s3Prefix.map(value => value),
        exportOnly.map(value => value)
      )
    def exportTaskIdentifier: String
    def sourceArn: String
    def s3BucketName: String
    def iamRoleArn: String
    def kmsKeyId: String
    def s3Prefix: Optional[String]
    def exportOnly: Optional[List[String]]
    def getExportTaskIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(exportTaskIdentifier)
    def getSourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(sourceArn)
    def getS3BucketName: ZIO[Any, Nothing, String] = ZIO.succeed(s3BucketName)
    def getIamRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(iamRoleArn)
    def getKmsKeyId: ZIO[Any, Nothing, String] = ZIO.succeed(kmsKeyId)
    def getS3Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
    def getExportOnly: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("exportOnly", exportOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StartExportTaskRequest
  ) extends zio.aws.rds.model.StartExportTaskRequest.ReadOnly {
    override val exportTaskIdentifier: String =
      impl.exportTaskIdentifier(): String
    override val sourceArn: String = impl.sourceArn(): String
    override val s3BucketName: String = impl.s3BucketName(): String
    override val iamRoleArn: String = impl.iamRoleArn(): String
    override val kmsKeyId: String = impl.kmsKeyId(): String
    override val s3Prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Prefix())
      .map(value => value: String)
    override val exportOnly: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.exportOnly())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StartExportTaskRequest
  ): zio.aws.rds.model.StartExportTaskRequest.ReadOnly = new Wrapper(impl)
}
